package seleniumConsulting.ch.selenium.framework.allure;

/**
 * This Enum maps the Keys for the allureText.properties.
 * This will be used to get the Text's for the Report.
 */
public enum AllureTextEnum {

    ValueChange("allure.valueChange"),
    Click("allure.click"),
    ScreenshotClick("allure.screenshotClick"),
    ScreenshotValueChange("allure.screenshotValueChange"),
    SendKeys("allure.sendKeys"),
    VideoDownload("allure.videoDownload"),
    VideoLinkName("allure.videoLinkName")
    ;

    /**
     * Value, which is used as Key in allureText.properties to Load the Text for Report
     */
    private String value;

    /**
     * @param value which is used as Key
     */
    AllureTextEnum(String value) {
        this.value = value;
    }

    /**
     * @return value of Enum (Key for allureText.properties)
     */
    public String getValue() {
        return value;
    }
}
