/*
 * Decompiled with CFR 0.152.
 */
package org.testng.annotations;

import org.testng.IMethodInstance;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Ignore;
import org.testng.annotations.Test;
import org.testng.util.Strings;

public class TestUtil {
    public static Test getTestAnnotation(IMethodInstance methodInstance) {
        return methodInstance.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class);
    }

    public static Test getTestAnnotation(ITestResult testResult) {
        return TestUtil.getTestAnnotation(testResult.getMethod());
    }

    public static Test getTestAnnotation(ITestNGMethod method) {
        return method.getConstructorOrMethod().getMethod().getAnnotation(Test.class);
    }

    public static boolean isIgnoredTest(ITestResult testResult) {
        return testResult.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Ignore.class);
    }

    public static boolean isIgnoredTest(ITestNGMethod method) {
        return method.getConstructorOrMethod().getMethod().isAnnotationPresent(Ignore.class);
    }

    public static boolean isIgnoredTest(IMethodInstance methodInstance) {
        return methodInstance.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Ignore.class);
    }

    public static boolean isWebTest(ITestResult testResult) {
        return TestUtil.getTestAnnotation(testResult.getMethod()).seleniumTest();
    }

    public static boolean isWebTest(ITestNGMethod method) {
        return TestUtil.getTestAnnotation(method).seleniumTest();
    }

    public static boolean isWebTest(IMethodInstance methodInstance) {
        return TestUtil.getTestAnnotation(methodInstance).seleniumTest();
    }

    public static boolean isDataProvided(IMethodInstance methodInstance) {
        return Strings.isNotNullAndNotEmpty((String)TestUtil.getTestAnnotation(methodInstance).dataProvider());
    }

    public static boolean isDataProvided(ITestNGMethod method) {
        return Strings.isNotNullAndNotEmpty((String)TestUtil.getTestAnnotation(method).dataProvider());
    }

    public static boolean isDataProvided(ITestResult testResult) {
        return Strings.isNotNullAndNotEmpty((String)TestUtil.getTestAnnotation(testResult).dataProvider());
    }
}

