//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package org.testng.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface Test {
    String[] groups() default {};

    boolean enabled() default true;

    /** @deprecated */
    @Deprecated
    String[] parameters() default {};

    String[] dependsOnGroups() default {};

    String[] dependsOnMethods() default {};

    long timeOut() default 0L;

    long invocationTimeOut() default 0L;

    int invocationCount() default 1;

    int threadPoolSize() default 0;

    int successPercentage() default 100;

    String dataProvider() default "";

    Class<?> dataProviderClass() default Object.class;

    boolean alwaysRun() default false;

    String description() default "";

    Class[] expectedExceptions() default {};

    String expectedExceptionsMessageRegExp() default ".*";

    String suiteName() default "";

    String testName() default "";

    /** @deprecated */
    boolean sequential() default false;

    boolean singleThreaded() default false;

    Class retryAnalyzer() default Class.class;

    boolean skipFailedInvocations() default false;

    boolean ignoreMissingDependencies() default false;

    int priority() default 0;

    boolean seleniumTest() default false;

    /**
     * Define your Browser-String-Array
     * Browsers = {android, chrome, firefox, htmlunit, internet explorer, iPhone, iPad, opera, safari} or nothing to define in data.properties
     * Optional: You are able to define the Version after the Browser
     * e.g. browser={"browser=internet explorer", "browser=firefox"} or browser={"browser=internet explorer&amp;version=11", "browser=firefox&amp;version=50"}
     * @return String[] of browser config
     */
    String[] browser() default {};

    /**
     * Define your Browser-Capibilities
     * capibilities = {"javascriptEnabled=true", "databaseEnabled=true"}
     * This will add this Capibilities to the testconfig/data.properties and set it to the Browser
     * See: https://github.com/SeleniumHQ/selenium/wiki/DesiredCapabilities
     * @return String[] of caplibilities
     */
    String[] capibilities() default {};
}
