package seleniumConsulting.ch.selenium.framework.metadata;

import java.util.HashMap;
import java.util.Map;

import org.testng.IMethodInstance;
import org.testng.ITestNGMethod;

/**
 * Stores Metadata to the TestMethods like Browser and Version
 */
public class MetadataManager {

    /**
     * Map<HashCodeOfITestNGMethod-Description, Map<MetadataKey, Object>> to store Metadata
     */
    static Map<Integer, Map<String, Object>> metadataMap = new HashMap();

    /**
     * Get Metadata to {@link IMethodInstance} and a Key
     * @param mapKey to get the right store-Map
     * @param key to get the Value
     * @return Object value of Store returns "" if ther is no value in store
     */
    public static Object getMetadata(ITestNGMethod mapKey, String key) {
        Map<String, Object> map = getMetadataMap(mapKey);
        if(map != null){
            return map.get(key);
        } else {
            return "";
        }

    }

    /**
     * Set Metadata to {@link IMethodInstance} and a Key
     * @param mapKey to get the right store-Map
     * @param key to set the Value
     * @param object Value to store
     */
    public static void setMetadata(IMethodInstance mapKey, String key, Object object) {
        setMetadata(mapKey.getMethod(), key,object);
    }

    /**
     * Set Metadata to {@link ITestNGMethod} and a Key
     * @param mapKey to get the right store-Map
     * @param key to set the Value
     * @param object Value to store
     */
    public static void setMetadata(ITestNGMethod mapKey, String key, Object object) {
        Map<String, Object> map = getMetadataMap(mapKey);
        if(map != null){
            map.put(key, object);
        }
    }
    /**
     * Del Metadata to {@link ITestNGMethod}
     * @param mapKey to remove the right store-Map
     */
    public static void delMetadata(ITestNGMethod mapKey) {
        metadataMap.remove(getHashOfMethodDescription(mapKey));
    }

    /**
     * Get the store-Map to the {@link IMethodInstance}
     * @param mapKey to get the Map
     * @return Map or {@code null} if there is no Map
     */
    private static Map<String, Object> getMetadataMap(ITestNGMethod mapKey){
        if(mapKey.getDescription() != null){
            Map map = metadataMap.get(getHashOfMethodDescription(mapKey));
            if(map == null){
                metadataMap.put(getHashOfMethodDescription(mapKey), new HashMap<>());
                map = metadataMap.get(getHashOfMethodDescription(mapKey));
            }
            return map;
        } else {
            return null;
        }
    }

    /**
     * Get Hashcode of the Method-Description
     * @param mapKey the method
     * @return Integer hashcode
     */
    private static Integer getHashOfMethodDescription(ITestNGMethod mapKey){
        return mapKey.getDescription().hashCode();

    }

}
