package vendors.grid;

import java.net.URL;
import java.util.Map;

import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.TestUtil;
import org.testng.util.Strings;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Allure;
import io.qameta.allure.model.Link;
import lombok.extern.slf4j.Slf4j;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverFactory;
import seleniumConsulting.ch.selenium.framework.metadata.MetadataKey;

@Slf4j
public class Element34VendorSBox implements VendorInterface {

    @Override
    public void addCapibilities(ITestNGMethod method, MutableCapabilities mutableCapabilities) {
        String name = TestUtil.getTestAnnotation(method).testName();
        name = Strings.isNotNullAndNotEmpty(name)? name : method.getMethodName();
        mutableCapabilities.setCapability("e34:l_testName", name);
    }

    @Override
    public void onTestSuccess(ITestResult iTestResult) {
    }

    @Override
    public void onTestFailure(ITestResult iTestResult) {

    }

    @Override
    public void onTestStart(ITestResult iTestResult) {

    }

    @Override
    public void onTestSkipped(ITestResult iTestResult) {

    }

    @Override
    public void createVideo(ITestResult iTestResult, SessionId sessionId) {
        createVideoLink(sessionId);
    }

    /**
     * Download the Video of a {@link org.openqa.selenium.remote.RemoteWebDriver}, if its not working, it will create a Link to the video in the Report
     * It will test is there a {@link org.openqa.selenium.remote.RemoteWebDriver} and is e34:video on in this Test
     * @param id of {@link org.openqa.selenium.remote.RemoteWebDriver} to download Video / create Link
     */
    private static void createVideoLink(SessionId id) {
        boolean isVideoActive = false;
        if (!Strings.isNullOrEmpty(System.getProperty(MetadataKey.CAPABILITIES))) {
            Map<String, String> map = ImmutableMap.copyOf(Splitter.on(',')
                    .withKeyValueSeparator("=")
                    .split(System.getProperty(MetadataKey.CAPABILITIES)));
            if (map.get("e34:video") != null && map.get("e34:video").equals("true")) {
                isVideoActive = true;
            }
        }
        if (id != null && isVideoActive) {
            saveVideo(id);
        }
    }

    /**
     * Report Allure Step 'Video Download' and adds the Video as Attachment.
     * If its not working will add Link to the Video to Report
     * @param id to the {@link org.openqa.selenium.remote.RemoteWebDriver}
     */
    private static void saveVideo(SessionId id) {
        try {
            AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.VideoDownload));
            Thread.sleep(200);
            Allure.addAttachment("Video", "video/mp4", new URL(System.getProperty(WebDriverFactory.REMOTE_GRID_URL)+"/videos/"+ id + ".mp4").openStream(), "mp4");
            AllureUtils.stopStepPassed();

        } catch (Exception e) {
            log.error("Downloading Video Faild, create Link");
            Allure.addLinks(new Link()
                    .setName(TestDataProvider.getTestData(AllureTextEnum.VideoLinkName))
                    .setUrl(System.getProperty(WebDriverFactory.REMOTE_GRID_URL)+"/videos/"+ id + ".mp4"));

        }
    }
}
