/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.config;

import com.github.sevtech.cloud.storage.spring.config.ConditionalOnCloudStorageProperty;
import com.github.sevtech.cloud.storage.spring.property.GoogleCloudStorageProperties;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import com.github.sevtech.cloud.storage.spring.service.impl.GoogleCloudStorageService;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnCloudStorageProperty(value="gcp.storage.enabled")
public class GoogleCloudStorageConfig {
    private static final Logger log = LoggerFactory.getLogger(GoogleCloudStorageConfig.class);

    @Bean
    public GoogleCloudStorageProperties googleCloudStorageProperties() {
        return new GoogleCloudStorageProperties();
    }

    @Bean
    public Storage storageClient(GoogleCloudStorageProperties googleCloudStorageProperties) throws IOException {
        log.info("Registering Google Storage client");
        return (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(googleCloudStorageProperties.getKeyfile())))).build().getService();
    }

    @Bean
    public StorageService googleCloudStorageService(Storage storageClient) {
        return new GoogleCloudStorageService(storageClient);
    }
}

