/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.service.impl;

import com.amazonaws.util.IOUtils;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.github.sevtech.cloud.storage.spring.bean.BaseResponse;
import com.github.sevtech.cloud.storage.spring.bean.DeleteFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.DeleteFileResponse;
import com.github.sevtech.cloud.storage.spring.bean.GetFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.GetFileResponse;
import com.github.sevtech.cloud.storage.spring.bean.UploadFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.UploadFileResponse;
import com.github.sevtech.cloud.storage.spring.exception.NoBucketException;
import com.github.sevtech.cloud.storage.spring.service.AbstractStorageService;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

public class AzureBlobStorageService
extends AbstractStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(AzureBlobStorageService.class);
    @Value(value="${azure.blob.storage.container.name}")
    private String defaultContainerName;
    private final BlobServiceClient blobServiceClient;

    @Override
    public UploadFileResponse uploadFile(UploadFileRequest uploadFileRequest) {
        BaseResponse result;
        try {
            InputStream streamToUpload = this.clone(uploadFileRequest.getStream());
            BlockBlobClient blockBlobClient = this.getBlobClient(uploadFileRequest.getBucketName(), this.getFilePath(uploadFileRequest));
            BlobHttpHeaders headers = new BlobHttpHeaders();
            headers.setContentType(uploadFileRequest.getContentType());
            blockBlobClient.upload(streamToUpload, (long)IOUtils.toByteArray((InputStream)uploadFileRequest.getStream()).length);
            blockBlobClient.setHttpHeaders(headers);
            result = ((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(uploadFileRequest.getName())).status(200)).comment(blockBlobClient.getBlobUrl())).build();
        }
        catch (NoBucketException | IOException e) {
            log.warn("Error creating blob");
            result = ((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(uploadFileRequest.getName())).status(500)).cause("Error creating blob")).exception(e)).build();
        }
        return result;
    }

    @Override
    @Async
    public Future<UploadFileResponse> uploadFileAsync(UploadFileRequest request) {
        return new AsyncResult((Object)this.uploadFile(request));
    }

    @Override
    public GetFileResponse getFile(GetFileRequest request) {
        BaseResponse result;
        log.info("Reading file from Azure {}", (Object)request.getPath());
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            BlockBlobClient blockBlobClient = this.getBlobClient(request.getBucketName(), request.getPath());
            blockBlobClient.download((OutputStream)outputStream);
            result = ((GetFileResponse.GetFileResponseBuilder)((BaseResponse.BaseResponseBuilder)GetFileResponse.builder().content(outputStream.toByteArray())).status(200)).build();
        }
        catch (NoBucketException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            result = ((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)GetFileResponse.builder().cause(e.getMessage())).exception(e)).status(500)).build();
        }
        return result;
    }

    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest request) {
        BaseResponse result;
        log.info("Deleting file from Azure {}", (Object)request.getPath());
        try {
            BlockBlobClient blockBlobClient = this.getBlobClient(request.getBucketName(), request.getPath());
            blockBlobClient.delete();
            result = ((DeleteFileResponse.DeleteFileResponseBuilder)DeleteFileResponse.builder().status(200)).build();
        }
        catch (NoBucketException e) {
            log.error(e.getMessage(), (Throwable)e);
            result = ((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)DeleteFileResponse.builder().cause(e.getMessage())).exception(e)).status(500)).build();
        }
        return result;
    }

    private BlockBlobClient getBlobClient(String bucketName, String path) throws NoBucketException {
        return this.blobServiceClient.getBlobContainerClient(this.getBucketName(bucketName, this.defaultContainerName)).getBlobClient(path).getBlockBlobClient();
    }

    public AzureBlobStorageService(BlobServiceClient blobServiceClient) {
        this.blobServiceClient = blobServiceClient;
    }
}

