/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.service.impl;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.github.sevtech.cloud.storage.spring.bean.BaseResponse;
import com.github.sevtech.cloud.storage.spring.bean.DeleteFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.DeleteFileResponse;
import com.github.sevtech.cloud.storage.spring.bean.GetFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.GetFileResponse;
import com.github.sevtech.cloud.storage.spring.bean.UploadFileRequest;
import com.github.sevtech.cloud.storage.spring.bean.UploadFileResponse;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import java.io.IOException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

public class DropboxService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(DropboxService.class);
    private final DbxClientV2 dbxClientV2;

    @Override
    public UploadFileResponse uploadFile(UploadFileRequest request) {
        BaseResponse result;
        try {
            this.dbxClientV2.files().uploadBuilder("/" + request.getFolder() + "/" + request.getName()).uploadAndFinish(request.getStream());
            result = ((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(request.getName())).status(200)).build();
        }
        catch (DbxException | IOException e) {
            result = ((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(request.getName())).status(500)).cause(e.getLocalizedMessage())).exception((Exception)e)).build();
        }
        return result;
    }

    @Override
    @Async
    public Future<UploadFileResponse> uploadFileAsync(UploadFileRequest request) {
        return new AsyncResult((Object)this.uploadFile(request));
    }

    @Override
    public GetFileResponse getFile(GetFileRequest request) {
        BaseResponse result;
        try {
            DbxDownloader download = this.dbxClientV2.files().download(request.getPath());
            result = ((GetFileResponse.GetFileResponseBuilder)((BaseResponse.BaseResponseBuilder)GetFileResponse.builder().content(new byte[download.getInputStream().available()])).status(200)).build();
        }
        catch (DbxException | IOException e) {
            result = ((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)GetFileResponse.builder().status(500)).cause(e.getLocalizedMessage())).exception((Exception)e)).build();
        }
        return result;
    }

    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest request) {
        BaseResponse result;
        try {
            this.dbxClientV2.files().deleteV2(request.getPath());
            result = ((DeleteFileResponse.DeleteFileResponseBuilder)((BaseResponse.BaseResponseBuilder)DeleteFileResponse.builder().result(true)).status(200)).build();
        }
        catch (DbxException e) {
            result = ((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)DeleteFileResponse.builder().status(500)).cause(e.getLocalizedMessage())).exception((Exception)((Object)e))).build();
        }
        return result;
    }

    public DropboxService(DbxClientV2 dbxClientV2) {
        this.dbxClientV2 = dbxClientV2;
    }
}

