/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.http.async.handler;

import com.github.shoothzj.javatool.http.async.HttpCallback;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHandler
implements FutureCallback<HttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(BasicHandler.class);
    private final Executor executor;
    private final HttpCallback httpCallback;

    public BasicHandler(Executor executor, HttpCallback httpCallback) {
        this.executor = executor;
        this.httpCallback = httpCallback;
    }

    public void completed(HttpResponse result) {
        try {
            if (result == null) {
                throw new IllegalArgumentException("Http response is null");
            }
            int statusCode = result.getStatusLine().getStatusCode();
            Header[] allHeaders = result.getAllHeaders();
            HashMap aux = new HashMap();
            Arrays.stream(allHeaders).forEach(header -> aux.put(header.getName(), header.getValue()));
            String content = EntityUtils.toString((HttpEntity)result.getEntity());
            this.executor.execute(() -> this.httpCallback.handleResponse(statusCode, aux, content));
        }
        catch (Exception e) {
            this.executor.execute(() -> this.httpCallback.handleException(e));
        }
    }

    public void failed(Exception ex) {
        this.executor.execute(() -> this.httpCallback.handleException(ex));
    }

    public void cancelled() {
        this.executor.execute(() -> this.httpCallback.handleException(new IllegalArgumentException("Http request has been canceled")));
    }
}

