/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.test.http.server;

import com.github.shoothzj.javatool.test.http.server.TestHttpHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHttpServer {
    private static final Logger log = LoggerFactory.getLogger(TestHttpServer.class);
    private final Executor executor = Executors.newSingleThreadExecutor();

    public TestHttpServer(String host, int port) throws Exception {
        this.executor.execute(() -> {
            NioEventLoopGroup bossGroup = new NioEventLoopGroup();
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            try {
                ServerBootstrap b = new ServerBootstrap();
                ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel ch) throws Exception {
                        ch.pipeline().addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                        ch.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                        ch.pipeline().addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                        ch.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                        ch.pipeline().addLast("business", (ChannelHandler)new TestHttpHandler());
                    }
                });
                ChannelFuture cf = b.bind(host, port);
                cf.channel().closeFuture().sync();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                bossGroup.shutdownGracefully();
                workerGroup.shutdownGracefully();
            }
        });
    }
}

