/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.tool;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOTool {
    private static final Logger log = LoggerFactory.getLogger(IOTool.class);

    public static String readFile2String(String fileName) {
        try {
            return IOTool.read2String(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e) {
            log.error("file not found exception is {}", (Throwable)e);
            return "";
        }
    }

    public static String read2String(InputStream inputStream) {
        return IOTool.read2StringCharset(inputStream, "utf-8");
    }

    public static String read2StringCharset(InputStream inputStream, String charset) {
        try {
            return new String(IOTool.read2Byte(inputStream), charset);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnSupport encoding error error, exception is {}", (Throwable)e);
            return "";
        }
    }

    public static byte[] read2Byte(InputStream inputStream) {
        try {
            byte[] bytes = IOUtils.readFully((InputStream)new BufferedInputStream(inputStream), (int)inputStream.available());
            return bytes;
        }
        catch (IOException e) {
            log.error("Read File error, exception is {}", (Throwable)e);
            return new byte[0];
        }
    }
}

