/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonService {
    private static final Logger log = LoggerFactory.getLogger(JacksonService.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toJson(Object o) {
        try {
            return mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            log.error("json process error, exception is {}", (Throwable)e);
            return "";
        }
    }

    public static <T> T toObject(String json, Class<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (Exception e) {
            log.error("json process error, exception is {}", (Throwable)e);
            return null;
        }
    }

    public static <T> T toRefer(String json, TypeReference reference) {
        try {
            return (T)mapper.readValue(json, reference);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    }
}

