/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator;

import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.operator.AbstractOperator;
import com.github.sidhant92.boolparser.operator.EqualsOperator;
import com.github.sidhant92.boolparser.operator.GreaterThanEqualOperator;
import com.github.sidhant92.boolparser.operator.GreaterThanOperator;
import com.github.sidhant92.boolparser.operator.InOperator;
import com.github.sidhant92.boolparser.operator.LessThanEqualOperator;
import com.github.sidhant92.boolparser.operator.LessThanOperator;
import com.github.sidhant92.boolparser.operator.NotEqualsOperator;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class OperatorFactory {
    private static final Map<Operator, AbstractOperator> operatorMap = new EnumMap<Operator, AbstractOperator>(Operator.class);

    private OperatorFactory() {
    }

    public static void initialize() {
        EqualsOperator equalsOperator = new EqualsOperator();
        operatorMap.put(Operator.EQUALS, equalsOperator);
        operatorMap.put(Operator.GREATER_THAN, new GreaterThanOperator());
        operatorMap.put(Operator.GREATER_THAN_EQUAL, new GreaterThanEqualOperator());
        operatorMap.put(Operator.LESS_THAN, new LessThanOperator());
        operatorMap.put(Operator.LESS_THAN_EQUAL, new LessThanEqualOperator());
        operatorMap.put(Operator.NOT_EQUAL, new NotEqualsOperator());
        operatorMap.put(Operator.IN, new InOperator(equalsOperator));
    }

    public static AbstractOperator getOperator(Operator operator) {
        return operatorMap.get((Object)operator);
    }

    public static List<AbstractOperator> getAllOperators() {
        return new ArrayList<AbstractOperator>(operatorMap.values());
    }

    public static void register(AbstractOperator abstractOperator) {
        operatorMap.put(abstractOperator.getOperator(), abstractOperator);
    }
}

