/*
 * Decompiled with CFR 0.152.
 */
package com.github.silencesu.behavior3java.core;

import com.github.silencesu.behavior3java.core.BaseNode;
import com.github.silencesu.behavior3java.core.BehaviorTree;
import com.github.silencesu.behavior3java.core.Blackboard;
import java.util.ArrayList;
import java.util.List;

public class Tick {
    private BehaviorTree tree;
    private Blackboard blackboard;
    private List<BaseNode> openNodes = new ArrayList<BaseNode>();
    Object target;
    private int nodeCount;

    public Tick() {
        this.initialize();
    }

    public void initialize() {
        this.tree = null;
        this.blackboard = null;
        this.openNodes = new ArrayList<BaseNode>();
        this.nodeCount = 0;
    }

    public String treeId() {
        return this.getTree().getId();
    }

    public BehaviorTree getTree() {
        return this.tree;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public void enterNode(BaseNode node) {
        ++this.nodeCount;
        this.openNodes.add(node);
    }

    public void openNode(BaseNode node) {
    }

    public void tickNode(BaseNode node) {
    }

    public void closeNode(BaseNode node) {
        if (this.openNodes.size() > 0) {
            this.openNodes.remove(node);
        }
    }

    public void exitNNode(BaseNode node) {
    }

    public List<BaseNode> getOpenNodes() {
        return this.openNodes;
    }

    public Object getTarget() {
        return this.target;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setTree(BehaviorTree tree) {
        this.tree = tree;
    }

    public void setBlackboard(Blackboard blackboard) {
        this.blackboard = blackboard;
    }

    public void setOpenNodes(List<BaseNode> openNodes) {
        this.openNodes = openNodes;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tick)) {
            return false;
        }
        Tick other = (Tick)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BehaviorTree this$tree = this.getTree();
        BehaviorTree other$tree = other.getTree();
        if (this$tree == null ? other$tree != null : !((Object)this$tree).equals(other$tree)) {
            return false;
        }
        Blackboard this$blackboard = this.getBlackboard();
        Blackboard other$blackboard = other.getBlackboard();
        if (this$blackboard == null ? other$blackboard != null : !((Object)this$blackboard).equals(other$blackboard)) {
            return false;
        }
        List<BaseNode> this$openNodes = this.getOpenNodes();
        List<BaseNode> other$openNodes = other.getOpenNodes();
        if (this$openNodes == null ? other$openNodes != null : !((Object)this$openNodes).equals(other$openNodes)) {
            return false;
        }
        Object this$target = this.getTarget();
        Object other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        return this.getNodeCount() == other.getNodeCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tick;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BehaviorTree $tree = this.getTree();
        result = result * 59 + ($tree == null ? 43 : ((Object)$tree).hashCode());
        Blackboard $blackboard = this.getBlackboard();
        result = result * 59 + ($blackboard == null ? 43 : ((Object)$blackboard).hashCode());
        List<BaseNode> $openNodes = this.getOpenNodes();
        result = result * 59 + ($openNodes == null ? 43 : ((Object)$openNodes).hashCode());
        Object $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        result = result * 59 + this.getNodeCount();
        return result;
    }

    public String toString() {
        return "Tick(tree=" + this.getTree() + ", blackboard=" + this.getBlackboard() + ", openNodes=" + this.getOpenNodes() + ", target=" + this.getTarget() + ", nodeCount=" + this.getNodeCount() + ")";
    }
}

