/*
 * Decompiled with CFR 0.152.
 */
package com.github.silencesu.behavior3java.core;

import com.github.silencesu.behavior3java.config.BTNodeCfg;
import com.github.silencesu.behavior3java.constant.B3Status;
import com.github.silencesu.behavior3java.core.BehaviorTreeProject;
import com.github.silencesu.behavior3java.core.INode;
import com.github.silencesu.behavior3java.core.INodeWorker;
import com.github.silencesu.behavior3java.core.Tick;
import java.util.Map;

public abstract class BaseNode
implements INode,
INodeWorker {
    private String id;
    private String name;
    private String title;
    private String description;
    private Map<String, String> parameters;
    private Map<String, String> properties;
    protected BehaviorTreeProject projectInfo;

    @Override
    public void onEnter(Tick tick) {
    }

    @Override
    public void onOpen(Tick tick) {
    }

    @Override
    public void onClose(Tick tick) {
    }

    @Override
    public void onExit(Tick tick) {
    }

    @Override
    public void initialize(BTNodeCfg nodeCfg) {
        this.id = nodeCfg.getId();
        this.name = nodeCfg.getName();
        this.title = nodeCfg.getTitle();
        this.description = nodeCfg.getDescription();
        this.parameters = nodeCfg.getParameters();
        this.properties = nodeCfg.getProperties();
    }

    @Override
    public B3Status run(Tick tick) {
        B3Status status;
        this.enter(tick);
        if (!tick.getBlackboard().getBool("isOpen", tick.getTree().getId(), this.id).booleanValue()) {
            this.open(tick);
        }
        if ((status = this.tick(tick)) != B3Status.RUNNING) {
            this.onClose(tick);
        }
        this.exit(tick);
        return status;
    }

    @Override
    public void enter(Tick tick) {
        tick.enterNode(this);
        this.onEnter(tick);
    }

    @Override
    public void open(Tick tick) {
        tick.openNode(this);
        tick.getBlackboard().setParam("isOpen", true, tick.getTree().getId(), this.getId());
        this.onOpen(tick);
    }

    @Override
    public B3Status tick(Tick tick) {
        tick.tickNode(this);
        return this.onTick(tick);
    }

    @Override
    public void close(Tick tick) {
        tick.closeNode(this);
        tick.getBlackboard().setParam("isOpen", false, tick.getTree().getId(), this.getId());
        this.onClose(tick);
    }

    @Override
    public void exit(Tick tick) {
        tick.exitNNode(this);
        this.onExit(tick);
    }

    @Override
    public B3Status execute(Tick tick) {
        return this.run(tick);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public BehaviorTreeProject getProjectInfo() {
        return this.projectInfo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProjectInfo(BehaviorTreeProject projectInfo) {
        this.projectInfo = projectInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseNode)) {
            return false;
        }
        BaseNode other = (BaseNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        BehaviorTreeProject this$projectInfo = this.getProjectInfo();
        BehaviorTreeProject other$projectInfo = other.getProjectInfo();
        return !(this$projectInfo == null ? other$projectInfo != null : !((Object)this$projectInfo).equals(other$projectInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        BehaviorTreeProject $projectInfo = this.getProjectInfo();
        result = result * 59 + ($projectInfo == null ? 43 : ((Object)$projectInfo).hashCode());
        return result;
    }

    public String toString() {
        return "BaseNode(id=" + this.getId() + ", name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", parameters=" + this.getParameters() + ", properties=" + this.getProperties() + ", projectInfo=" + this.getProjectInfo() + ")";
    }
}

