/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.Immutable;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableCollectionUtils;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.collection.immutable.Pair;
import com.github.simonharmonicminor.juu.collection.immutable.UnmodifiableIterator;
import com.github.simonharmonicminor.juu.monad.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ImmutableArrayList<T>
implements ImmutableList<T>,
Serializable {
    private final ArrayList<T> arrayList;

    public ImmutableArrayList(Iterable<T> iterable) {
        this(iterable, true);
    }

    ImmutableArrayList(Iterable<T> iterable, boolean needCloning) {
        Objects.requireNonNull(iterable);
        if (iterable instanceof ArrayList) {
            this.arrayList = needCloning ? new ArrayList((ArrayList)iterable) : (ArrayList)iterable;
        } else if (iterable instanceof ImmutableArrayList) {
            ImmutableArrayList immutableArrayList = (ImmutableArrayList)iterable;
            this.arrayList = immutableArrayList.arrayList;
        } else {
            this.arrayList = new ArrayList();
            for (T element : iterable) {
                this.arrayList.add(element);
            }
        }
    }

    private int normalizeIndex(int index) {
        return index >= 0 ? index : this.size() + index;
    }

    private void checkStepSize(int stepSize) {
        if (stepSize == 0) {
            throw new IllegalArgumentException("Step size cannot be zero");
        }
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(String.format("Index %d is out of bounds", index));
        }
    }

    @Override
    public T get(int index) {
        int normalized = this.normalizeIndex(index);
        this.checkIndex(normalized);
        return this.arrayList.get(normalized);
    }

    @Override
    public OptionalInt indexOf(T element) {
        int index = this.arrayList.indexOf(element);
        if (index == -1) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(index);
    }

    @Override
    public OptionalInt lastIndexOf(T element) {
        int index = this.arrayList.lastIndexOf(element);
        if (index == -1) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(index);
    }

    @Override
    public ImmutableList<T> slice(int fromIndex) {
        return this.slice(fromIndex, this.size(), 1);
    }

    @Override
    public ImmutableList<T> slice(int fromIndex, int toIndex) {
        int toNorm;
        int fromNorm;
        return this.slice(fromNorm, toNorm, (fromNorm = this.normalizeIndex(fromIndex)) < (toNorm = this.normalizeIndex(toIndex)) ? 1 : -1);
    }

    @Override
    public ImmutableList<T> slice(int fromIndex, int toIndex, int stepSize) {
        int fromNorm = this.normalizeIndex(fromIndex);
        int toNorm = this.normalizeIndex(toIndex);
        this.checkIndex(fromNorm);
        this.checkStepSize(stepSize);
        BiFunction<Integer, Integer, Boolean> condition = fromNorm <= toNorm ? (from, to) -> from < to && from < this.size() : (from, to) -> from > to && from >= 0;
        Function<Integer, Integer> nextValueFunc = index -> index + stepSize;
        ArrayList<T> newArrayList = new ArrayList<T>();
        while (condition.apply(fromNorm, toNorm).booleanValue()) {
            newArrayList.add(this.get(fromNorm));
            fromNorm = nextValueFunc.apply(fromNorm);
        }
        return Immutable.listOfWithoutCloning(newArrayList);
    }

    @Override
    public ImmutableList<T> step(int stepSize) {
        if (stepSize > 0) {
            return this.step(0, stepSize);
        }
        return this.step(-1, stepSize);
    }

    @Override
    public ImmutableList<T> step(int fromIndex, int stepSize) {
        this.checkStepSize(stepSize);
        this.checkIndex(this.normalizeIndex(fromIndex));
        if (stepSize > 0) {
            return this.slice(fromIndex, this.size(), stepSize);
        }
        return this.slice(fromIndex, -this.size() - 1, stepSize);
    }

    @Override
    public ImmutableList<T> concatWith(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        ArrayList<T> copy = new ArrayList<T>(this.arrayList);
        for (T t : iterable) {
            copy.add(t);
        }
        return Immutable.listOfWithoutCloning(copy);
    }

    private static <R> R getValByIndex(ImmutableList<R> immutableList, int index) {
        if (index < immutableList.size()) {
            return immutableList.get(index);
        }
        return null;
    }

    @Override
    public <R> ImmutableList<Pair<T, R>> zipWith(ImmutableList<R> list) {
        Objects.requireNonNull(list);
        int maxSize = Math.max(this.size(), list.size());
        ArrayList<Pair<R, R>> newArrayList = new ArrayList<Pair<R, R>>(maxSize);
        for (int i = 0; i < maxSize; ++i) {
            R left = ImmutableArrayList.getValByIndex(this, i);
            R right = ImmutableArrayList.getValByIndex(list, i);
            newArrayList.add(Pair.of(left, right));
        }
        return Immutable.listOfWithoutCloning(newArrayList);
    }

    @Override
    public ImmutableList<Pair<T, T>> zipWithNext() {
        ArrayList<Pair<T, T>> newArrayList = new ArrayList<Pair<T, T>>(this.size());
        for (int i = 0; i < this.size() - 1; ++i) {
            newArrayList.add(Pair.of(this.get(i), this.get(i + 1)));
        }
        return Immutable.listOfWithoutCloning(newArrayList);
    }

    @Override
    public <R> ImmutableList<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        ArrayList<R> newList = new ArrayList<R>(this.arrayList.size());
        for (T t : this.arrayList) {
            newList.add(mapper.apply(t));
        }
        return Immutable.listOfWithoutCloning(newList);
    }

    @Override
    public <R> ImmutableList<R> mapIndexed(BiFunction<Integer, ? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        ArrayList<R> newList = new ArrayList<R>(this.arrayList.size());
        for (int i = 0; i < this.arrayList.size(); ++i) {
            newList.add(mapper.apply(i, (Integer)this.arrayList.get(i)));
        }
        return Immutable.listOfWithoutCloning(newList);
    }

    @Override
    public <R> ImmutableList<R> flatMap(Function<? super T, ? extends Iterable<R>> mapper) {
        Objects.requireNonNull(mapper);
        ArrayList<T> newList = new ArrayList<T>(this.arrayList.size());
        for (T t : this.arrayList) {
            ImmutableArrayList<R> listElement = new ImmutableArrayList<R>(mapper.apply(t));
            newList.addAll(listElement.arrayList);
        }
        return Immutable.listOfWithoutCloning(newList);
    }

    @Override
    public <R> ImmutableList<R> flatMapIndexed(BiFunction<Integer, ? super T, ? extends Iterable<R>> mapper) {
        Objects.requireNonNull(mapper);
        ArrayList<T> newList = new ArrayList<T>(this.arrayList.size());
        for (int i = 0; i < this.arrayList.size(); ++i) {
            ImmutableArrayList<R> listElement = new ImmutableArrayList<R>(mapper.apply(i, (Integer)this.arrayList.get(i)));
            newList.addAll(listElement.arrayList);
        }
        return Immutable.listOfWithoutCloning(newList);
    }

    @Override
    public ImmutableList<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        ArrayList<T> newList = new ArrayList<T>(this.arrayList.size());
        for (T t : this.arrayList) {
            if (!predicate.test(t)) continue;
            newList.add(t);
        }
        return Immutable.listOfWithoutCloning(newList);
    }

    @Override
    public ImmutableList<T> filterIndexed(BiPredicate<Integer, ? super T> predicate) {
        Objects.requireNonNull(predicate);
        ArrayList<T> newList = new ArrayList<T>(this.arrayList.size());
        for (int i = 0; i < this.arrayList.size(); ++i) {
            if (!predicate.test(i, (Integer)this.arrayList.get(i))) continue;
            newList.add(this.arrayList.get(i));
        }
        return Immutable.listOfWithoutCloning(newList);
    }

    @Override
    public void forEachIndexed(BiConsumer<Integer, ? super T> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.arrayList.size(); ++i) {
            action.accept(i, (Integer)this.arrayList.get(i));
        }
    }

    @Override
    public ImmutableList<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        ArrayList<T> copy = new ArrayList<T>(this.arrayList);
        copy.sort(comparator);
        return Immutable.listOfWithoutCloning(copy);
    }

    @Override
    public ImmutableList<T> limit(int size) {
        if (size < 0) {
            throw new IllegalArgumentException(String.format("Limit size is less than zero: %s", size));
        }
        ArrayList<T> newList = new ArrayList<T>(this.arrayList.size());
        for (int i = 0; i < Math.min(this.size(), size); ++i) {
            newList.add(this.arrayList.get(i));
        }
        return Immutable.listOfWithoutCloning(newList);
    }

    @Override
    public ImmutableList<T> skip(int size) {
        if (size < 0) {
            throw new IllegalArgumentException(String.format("Skip size is less than zero: %s", size));
        }
        ArrayList<T> newList = new ArrayList<T>(this.arrayList.size());
        for (int i = Math.min(size, this.size()); i < this.arrayList.size(); ++i) {
            newList.add(this.arrayList.get(i));
        }
        return Immutable.listOfWithoutCloning(newList);
    }

    @Override
    public ImmutableList<T> reversed() {
        return this.step(-1);
    }

    @Override
    public int size() {
        return this.arrayList.size();
    }

    @Override
    public boolean contains(Object element) {
        return Try.of(() -> this.arrayList.contains(element)).orElse(false);
    }

    @Override
    public ImmutableList<T> toList() {
        return this;
    }

    @Override
    public ImmutableSet<T> toSet() {
        return Immutable.setOf(this.arrayList);
    }

    @Override
    public Stream<T> parallelStream() {
        return this.arrayList.parallelStream();
    }

    @Override
    public Stream<T> stream() {
        return this.arrayList.stream();
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator<T>(this.arrayList.iterator());
    }

    @Override
    public boolean equals(Object o) {
        return ImmutableCollectionUtils.listEquals(this, o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arrayList);
    }

    public String toString() {
        return ImmutableCollectionUtils.listToString(this);
    }
}

