/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.Immutable;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableCollectionUtils;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.collection.immutable.UnmodifiableIterator;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ImmutableHashSet<T>
implements ImmutableSet<T>,
Serializable {
    private final HashSet<T> hashSet;

    public ImmutableHashSet(Iterable<T> iterable) {
        this(iterable, true);
    }

    ImmutableHashSet(Iterable<T> iterable, boolean needsCloning) {
        Objects.requireNonNull(iterable);
        if (iterable instanceof HashSet) {
            this.hashSet = needsCloning ? new HashSet((HashSet)iterable) : (HashSet)iterable;
        } else if (iterable instanceof ImmutableHashSet) {
            ImmutableHashSet immutableHashSet = (ImmutableHashSet)iterable;
            this.hashSet = immutableHashSet.hashSet;
        } else {
            this.hashSet = new HashSet();
            for (T element : iterable) {
                this.hashSet.add(element);
            }
        }
    }

    @Override
    public ImmutableSet<T> concatWith(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        HashSet<T> newHashSet = new HashSet<T>(this.hashSet);
        for (T t : iterable) {
            newHashSet.add(t);
        }
        return Immutable.setOfWithoutCloning(newHashSet);
    }

    @Override
    public <R> ImmutableSet<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        HashSet<R> newHashSet = new HashSet<R>(this.size());
        for (T t : this) {
            newHashSet.add(mapper.apply(t));
        }
        return Immutable.setOfWithoutCloning(newHashSet);
    }

    @Override
    public <R> ImmutableSet<R> flatMap(Function<? super T, ? extends Iterable<R>> mapper) {
        Objects.requireNonNull(mapper);
        HashSet<T> newHashSet = new HashSet<T>(this.size());
        for (T t : this) {
            ImmutableHashSet<R> immutableHashSet = new ImmutableHashSet<R>(mapper.apply(t));
            newHashSet.addAll(immutableHashSet.hashSet);
        }
        return Immutable.setOfWithoutCloning(newHashSet);
    }

    @Override
    public ImmutableSet<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        HashSet<T> newHashSet = new HashSet<T>(this.size());
        for (T t : this) {
            if (!predicate.test(t)) continue;
            newHashSet.add(t);
        }
        return Immutable.setOfWithoutCloning(newHashSet);
    }

    @Override
    public int size() {
        return this.hashSet.size();
    }

    @Override
    public boolean contains(Object element) {
        return this.hashSet.contains(element);
    }

    @Override
    public ImmutableList<T> toList() {
        return Immutable.listOf(this.hashSet);
    }

    @Override
    public ImmutableSet<T> toSet() {
        return this;
    }

    @Override
    public Stream<T> parallelStream() {
        return this.hashSet.parallelStream();
    }

    @Override
    public Stream<T> stream() {
        return this.hashSet.stream();
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator<T>(this.hashSet.iterator());
    }

    @Override
    public boolean equals(Object o) {
        return ImmutableCollectionUtils.setEquals(this, o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hashSet);
    }

    public String toString() {
        return ImmutableCollectionUtils.setToString(this);
    }
}

