/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.collection.immutable.Pair;
import com.github.simonharmonicminor.juu.lambda.TriFunction;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public interface ImmutableMap<K, V> {
    public int size();

    public boolean isEmpty();

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean containsKey(Object var1);

    default public boolean notContainsKey(Object key) {
        return !this.containsKey(key);
    }

    public boolean containsValue(Object var1);

    default public boolean notContainsValue(Object value) {
        return !this.containsValue(value);
    }

    public boolean containsPair(Pair<K, V> var1);

    default public boolean notContainsPair(Pair<K, V> pair) {
        Objects.requireNonNull(pair);
        return !this.containsPair(pair);
    }

    public ImmutableMap<K, V> concatWithOverride(ImmutableMap<K, V> var1);

    public ImmutableMap<K, V> concatWithoutOverride(ImmutableMap<K, V> var1);

    public ImmutableMap<K, V> concatWith(ImmutableMap<K, V> var1, TriFunction<K, V, V, V> var2);

    public V get(Object var1);

    public ImmutableSet<K> keySet();

    public ImmutableList<V> values();

    public ImmutableSet<Pair<K, V>> pairSet();

    public Map<K, V> toMutableMap();

    public boolean equals(Object var1);

    public int hashCode();

    default public V getOrDefault(Object key, V defaultValue) {
        return this.containsKey(key) ? this.get(key) : defaultValue;
    }

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (Pair pair : this.pairSet()) {
            Object k = pair.getKey();
            Object v = pair.getValue();
            action.accept(k, v);
        }
    }
}

