/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.Immutable;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableCollectionUtils;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableMapUtils;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableNavigableMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableNavigableSet;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSortedMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableTreeSet;
import com.github.simonharmonicminor.juu.collection.immutable.Pair;
import com.github.simonharmonicminor.juu.lambda.TriFunction;
import com.github.simonharmonicminor.juu.monad.Try;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;

public class ImmutableTreeMap<K, V>
implements ImmutableNavigableMap<K, V>,
Serializable {
    private final TreeMap<K, V> treeMap;
    private final ImmutableSet<K> keys;
    private final ImmutableList<V> values;
    private final ImmutableSet<Pair<K, V>> pairs;

    public static <K, V> ImmutableTreeMap<K, V> of(Map<K, V> map, Comparator<? super K> comparator) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(comparator);
        return new ImmutableTreeMap<K, V>(map, comparator);
    }

    public static <K extends Comparable<K>, V> ImmutableTreeMap<K, V> of(Map<K, V> map) {
        Objects.requireNonNull(map);
        return new ImmutableTreeMap<K, V>(map, null);
    }

    public static <K, V> ImmutableTreeMap<K, V> ofSortedMap(SortedMap<K, V> sortedMap) {
        Objects.requireNonNull(sortedMap);
        return new ImmutableTreeMap<K, V>(sortedMap, true);
    }

    ImmutableTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        Objects.requireNonNull(map);
        this.treeMap = new TreeMap(comparator);
        map.forEach(this.treeMap::put);
        this.keys = Immutable.setOf(this.treeMap.keySet());
        this.values = Immutable.listOf(this.treeMap.values());
        this.pairs = ImmutableMapUtils.toPairSet(this.treeMap.entrySet());
    }

    ImmutableTreeMap(SortedMap<K, V> sortedMap, boolean needsCloning) {
        this.treeMap = sortedMap instanceof TreeMap ? (needsCloning ? new TreeMap<K, V>(sortedMap) : (TreeMap)sortedMap) : new TreeMap<K, V>(sortedMap);
        this.keys = Immutable.setOf(this.treeMap.keySet());
        this.values = Immutable.listOf(this.treeMap.values());
        this.pairs = ImmutableMapUtils.toPairSet(this.treeMap.entrySet());
    }

    @Override
    public Optional<Pair<K, V>> lowerPair(K key) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeMap.lowerEntry(key)).map(Pair::of);
    }

    @Override
    public Optional<K> lowerKey(K key) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeMap.lowerKey(key));
    }

    @Override
    public Optional<Pair<K, V>> floorPair(K key) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeMap.floorEntry(key)).map(Pair::of);
    }

    @Override
    public Optional<K> floorKey(K key) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeMap.floorKey(key));
    }

    @Override
    public Optional<Pair<K, V>> ceilingPair(K key) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeMap.ceilingEntry(key)).map(Pair::of);
    }

    @Override
    public Optional<K> ceilingKey(K key) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeMap.ceilingKey(key));
    }

    @Override
    public Optional<Pair<K, V>> higherPair(K key) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeMap.higherEntry(key)).map(Pair::of);
    }

    @Override
    public Optional<K> higherKey(K key) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeMap.higherKey(key));
    }

    @Override
    public Optional<Pair<K, V>> firstPair() {
        return ImmutableCollectionUtils.tryGetElement(this.treeMap::firstEntry).map(Pair::of);
    }

    @Override
    public Optional<Pair<K, V>> lastPair() {
        return ImmutableCollectionUtils.tryGetElement(this.treeMap::lastEntry).map(Pair::of);
    }

    @Override
    public ImmutableNavigableMap<K, V> reversedOrderMap() {
        return new ImmutableTreeMap<K, V>(this.treeMap.descendingMap(), false);
    }

    @Override
    public ImmutableNavigableSet<K> navigableKeySet() {
        return new ImmutableTreeSet<K>(this.treeMap.navigableKeySet(), false);
    }

    @Override
    public ImmutableNavigableSet<K> reversedOrderKeySet() {
        return new ImmutableTreeSet<K>(this.treeMap.descendingKeySet(), false);
    }

    private ImmutableNavigableMap<K, V> tryGetSubMap(Supplier<ImmutableNavigableMap<K, V>> supplier) {
        return Try.of(supplier::get).orElse(new ImmutableTreeMap(Collections.emptyMap(), this.treeMap.comparator()));
    }

    @Override
    public ImmutableNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.tryGetSubMap(() -> new ImmutableTreeMap<Object, V>(this.treeMap.subMap(fromKey, fromInclusive, toKey, toInclusive), false));
    }

    @Override
    public ImmutableNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return this.tryGetSubMap(() -> new ImmutableTreeMap<Object, V>(this.treeMap.headMap(toKey, inclusive), false));
    }

    @Override
    public ImmutableNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return this.tryGetSubMap(() -> new ImmutableTreeMap<Object, V>(this.treeMap.tailMap(fromKey, inclusive), false));
    }

    @Override
    public NavigableMap<K, V> toMutableNavigableMap() {
        return new TreeMap<K, V>(this.treeMap);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.treeMap.comparator();
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.tryGetSubMap(() -> new ImmutableTreeMap<Object, V>(this.treeMap.subMap(fromKey, toKey), false));
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K toKey) {
        return this.tryGetSubMap(() -> new ImmutableTreeMap<Object, V>(this.treeMap.headMap(toKey), false));
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K fromKey) {
        return this.tryGetSubMap(() -> new ImmutableTreeMap<Object, V>(this.treeMap.tailMap(fromKey), false));
    }

    @Override
    public Optional<K> firstKey() {
        return ImmutableCollectionUtils.tryGetElement(this.treeMap::firstKey);
    }

    @Override
    public Optional<K> lastKey() {
        return ImmutableCollectionUtils.tryGetElement(this.treeMap::lastKey);
    }

    @Override
    public SortedMap<K, V> toMutableSortedMap() {
        return this.toMutableNavigableMap();
    }

    @Override
    public int size() {
        return this.treeMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.treeMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return Try.of(() -> this.treeMap.containsKey(key)).orElse(false);
    }

    @Override
    public boolean containsValue(Object value) {
        return Try.of(() -> this.treeMap.containsValue(value)).orElse(false);
    }

    @Override
    public boolean containsPair(Pair<K, V> pair) {
        Objects.requireNonNull(pair);
        return this.pairSet().contains(pair);
    }

    @Override
    public ImmutableMap<K, V> concatWithOverride(ImmutableMap<K, V> map) {
        Objects.requireNonNull(map);
        return ImmutableMapUtils.concatenationWithOverride(this.treeMap, map);
    }

    @Override
    public ImmutableMap<K, V> concatWithoutOverride(ImmutableMap<K, V> map) {
        Objects.requireNonNull(map);
        return ImmutableMapUtils.concatenationWithoutOverride(this.treeMap, map);
    }

    @Override
    public ImmutableMap<K, V> concatWith(ImmutableMap<K, V> map, TriFunction<K, V, V, V> overrideBehaviour) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(overrideBehaviour);
        return ImmutableMapUtils.concatenation(this.treeMap, map, overrideBehaviour);
    }

    @Override
    public V get(Object key) {
        return Try.of(() -> this.treeMap.get(key)).orElse(null);
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.keys;
    }

    @Override
    public ImmutableList<V> values() {
        return this.values;
    }

    @Override
    public ImmutableSet<Pair<K, V>> pairSet() {
        return this.pairs;
    }

    @Override
    public Map<K, V> toMutableMap() {
        return new HashMap<K, V>(this.treeMap);
    }
}

