/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog;

import com.github.simonpercic.oklog.LogDataInterceptor;
import com.github.simonpercic.oklog.core.BaseLogDataInterceptor;
import com.github.simonpercic.oklog.core.BaseOkLogInterceptorBuilder;
import com.github.simonpercic.oklog.core.CompressionUtil;
import com.github.simonpercic.oklog.core.LogDataBuilder;
import com.github.simonpercic.oklog.core.LogDataConfig;
import com.github.simonpercic.oklog.core.LogInterceptor;
import com.github.simonpercic.oklog.core.LogManager;
import com.github.simonpercic.oklog.core.Logger;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class OkLogInterceptor
implements Interceptor {
    private final LogManager logManager;
    private final LogDataInterceptor logDataInterceptor;

    private OkLogInterceptor(String logUrlBase, LogInterceptor logInterceptor, Logger logger, boolean ignoreTimber, boolean withRequestBody, boolean shortenInfoUrl, @NotNull LogDataConfig logDataConfig) {
        this(new LogManager(logUrlBase, logInterceptor, logger, ignoreTimber, withRequestBody, shortenInfoUrl, logDataConfig, new CompressionUtil()));
    }

    OkLogInterceptor(LogManager logManager) {
        this.logManager = logManager;
        this.logDataInterceptor = new LogDataInterceptor();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        BaseLogDataInterceptor.RequestLogData requestLogData = this.logDataInterceptor.processRequest(chain);
        LogDataBuilder logDataBuilder = requestLogData.getLogData();
        long startNs = System.nanoTime();
        try {
            response = chain.proceed((Request)requestLogData.getRequest());
        }
        catch (Exception e) {
            logDataBuilder.requestFailed();
            this.logManager.log(logDataBuilder);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        logDataBuilder.responseDurationMs(tookMs);
        BaseLogDataInterceptor.ResponseLogData responseLogData = this.logDataInterceptor.processResponse(logDataBuilder, response);
        this.logManager.log(responseLogData.getLogData());
        return (Response)responseLogData.getResponse();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BaseOkLogInterceptorBuilder {
        public Builder setBaseUrl(String url) {
            this.baseSetBaseUrl(url);
            return this;
        }

        public Builder ignoreTimber(boolean ignoreTimber) {
            this.baseIgnoreTimber(ignoreTimber);
            return this;
        }

        @Deprecated
        public Builder useAndroidLog(boolean useAndroidLog) {
            this.ignoreTimber(!useAndroidLog);
            return this;
        }

        public Builder setLogInterceptor(LogInterceptor logInterceptor) {
            this.baseSetLogInterceptor(logInterceptor);
            return this;
        }

        public Builder setLogger(Logger logger) {
            this.baseLogger(logger);
            return this;
        }

        public Builder withRequestBody(boolean requestBody) {
            this.baseWithRequestBody(requestBody);
            return this;
        }

        public Builder shortenInfoUrl(boolean shortenInfoUrl) {
            this.baseShortenInfoUrl(shortenInfoUrl);
            return this;
        }

        public Builder withRequestMethod(boolean requestMethod) {
            this.baseWithRequestMethod(requestMethod);
            return this;
        }

        public Builder withRequestUrl(boolean requestUrl) {
            this.baseWithRequestUrl(requestUrl);
            return this;
        }

        public Builder withProtocol(boolean protocol) {
            this.baseWithProtocol(protocol);
            return this;
        }

        public Builder withRequestContentType(boolean requestContentType) {
            this.baseWithRequestContentType(requestContentType);
            return this;
        }

        public Builder withRequestContentLength(boolean requestContentLength) {
            this.baseWithRequestContentLength(requestContentLength);
            return this;
        }

        public Builder withRequestBodyState(boolean requestBodyState) {
            this.baseWithRequestBodyState(requestBodyState);
            return this;
        }

        public Builder withRequestHeaders(boolean requestHeaders) {
            this.baseWithRequestHeaders(requestHeaders);
            return this;
        }

        public Builder withRequestFailedState(boolean requestFailedState) {
            this.baseWithRequestFailedState(requestFailedState);
            return this;
        }

        public Builder withResponseCode(boolean responseCode) {
            this.baseWithResponseCode(responseCode);
            return this;
        }

        public Builder withResponseMessage(boolean responseMessage) {
            this.baseWithResponseMessage(responseMessage);
            return this;
        }

        public Builder withResponseUrl(boolean responseUrl) {
            this.baseWithResponseUrl(responseUrl);
            return this;
        }

        public Builder withResponseDuration(boolean responseDuration) {
            this.baseWithResponseDuration(responseDuration);
            return this;
        }

        public Builder withResponseSize(boolean responseSize) {
            this.baseWithResponseSize(responseSize);
            return this;
        }

        public Builder withResponseBodyState(boolean responseBodyState) {
            this.baseWithResponseBodyState(responseBodyState);
            return this;
        }

        public Builder withResponseHeaders(boolean responseHeaders) {
            this.baseWithResponseHeaders(responseHeaders);
            return this;
        }

        public Builder withNoLogData() {
            this.baseWithNoLogData();
            return this;
        }

        public Builder withAllLogData() {
            this.baseWithAllLogData();
            return this;
        }

        @NotNull
        public OkLogInterceptor build() {
            return new OkLogInterceptor(this.logUrlBase, this.logInterceptor, this.logger, this.ignoreTimber, this.requestBody, this.shortenInfoUrl, this.buildLogDataConfig());
        }
    }
}

