/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallmenu;

import com.github.smallmenu.date.Strtotime;
import com.github.smallmenu.util.CharUtils;
import com.github.smallmenu.util.FunUtils;
import com.github.smallmenu.util.StrUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public final class Fun {
    private Fun() {
        throw new AssertionError();
    }

    public static long time() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long microtime() {
        return System.currentTimeMillis();
    }

    public static long freeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long totalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long freeMemory(String sizeFormat) {
        long memory = Runtime.getRuntime().freeMemory();
        return sizeFormat != null ? FunUtils.sizeFormat(memory, sizeFormat) : memory;
    }

    public static long usedMemory(String sizeFormat) {
        long memory = Fun.totalMemory() - Fun.freeMemory();
        return sizeFormat != null ? FunUtils.sizeFormat(memory, sizeFormat) : memory;
    }

    public static long maxMemory(String sizeFormat) {
        long memory = Runtime.getRuntime().maxMemory();
        return sizeFormat != null ? FunUtils.sizeFormat(memory, sizeFormat) : memory;
    }

    public static long totalMemory(String sizeFormat) {
        long memory = Runtime.getRuntime().totalMemory();
        return sizeFormat != null ? FunUtils.sizeFormat(memory, sizeFormat) : memory;
    }

    public static boolean blank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtils.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean blankAll(CharSequence ... strs) {
        if (Fun.emptyArray(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (Fun.blank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean empty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean emptyAll(CharSequence ... strs) {
        if (Fun.emptyArray(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (Fun.empty(str)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean emptyArray(T[] array) {
        return array == null || array.length == 0;
    }

    public static String trim(CharSequence str) {
        return null == str ? null : StrUtils.trim(str, 0);
    }

    public static String ltrim(CharSequence str) {
        return null == str ? null : StrUtils.trim(str, -1);
    }

    public static String rtrim(CharSequence str) {
        return null == str ? null : StrUtils.trim(str, 1);
    }

    public static String trimToEmpty(CharSequence str) {
        return str == null ? "" : Fun.trim(str);
    }

    public static String trimToNull(CharSequence str) {
        String trimStr = Fun.trim(str);
        return "".equals(trimStr) ? null : trimStr;
    }

    public static int toInt(String str) {
        return Fun.toInt(str, 0);
    }

    public static int toInt(String str, int defalutValue) {
        if (str == null) {
            return defalutValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defalutValue;
        }
    }

    public static int intval(String str) {
        return Fun.toInt(str);
    }

    public static long longval(String str) {
        return Fun.toLong(str);
    }

    public static long toLong(String str) {
        return Fun.toLong(str, 0L);
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str, CharSequence ... searchStrs) {
        if (Fun.empty(str) || Fun.emptyArray(searchStrs)) {
            return false;
        }
        for (CharSequence checkStr : searchStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StrUtils.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StrUtils.equals(str1, str2, true);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return StrUtils.startWith(str, prefix, false);
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StrUtils.startWith(str, prefix, true);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return StrUtils.endWith(str, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StrUtils.endWith(str, suffix, true);
    }

    public static int strlen(CharSequence str) {
        return str == null ? 0 : str.length();
    }

    public static long toLong(String str, long defalutValue) {
        if (str == null) {
            return defalutValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defalutValue;
        }
    }

    public static String date() {
        return Fun.date("yyyy-MM-dd HH:mm:ss");
    }

    public static String date(long timestamp) {
        return Fun.date("yyyy-MM-dd HH:mm:ss", timestamp);
    }

    public static String date(String pattern) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String date(String pattern, long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(Math.abs(timestamp)), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static long strtotime() {
        return Instant.now().getEpochSecond();
    }

    public static long strtotime(String dateString) {
        return Strtotime.parse(dateString);
    }

    public static long strtotime(String dateString, Long timestamp) {
        return Strtotime.parse(dateString, timestamp);
    }
}

