/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallmenu.fun;

import com.github.smallmenu.Fun;
import com.github.smallmenu.digest.DigestAlgorithm;
import com.github.smallmenu.fun.HexFun;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestFun {
    private DigestFun() {
        throw new AssertionError();
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MessageDigest getMd5Digest() {
        return DigestFun.getDigest(DigestAlgorithm.MD5.value());
    }

    public static MessageDigest getSha1Digest() {
        return DigestFun.getDigest(DigestAlgorithm.SHA1.value());
    }

    public static MessageDigest getSha256Digest() {
        return DigestFun.getDigest(DigestAlgorithm.SHA256.value());
    }

    public static MessageDigest getSha384Digest() {
        return DigestFun.getDigest(DigestAlgorithm.SHA384.value());
    }

    public static MessageDigest getSha512Digest() {
        return DigestFun.getDigest(DigestAlgorithm.SHA512.value());
    }

    public static byte[] digest(MessageDigest messageDigest, byte[] data) {
        return messageDigest.digest(data);
    }

    public static byte[] md5(byte[] data) {
        return DigestFun.getMd5Digest().digest(data);
    }

    public static byte[] md5(String str) {
        return DigestFun.md5(Fun.bytes(str));
    }

    public static String md5Hex(byte[] data) {
        return HexFun.encodeHexString(DigestFun.md5(data));
    }

    public static String md5Hex(String str) {
        return HexFun.encodeHexString(DigestFun.md5(str));
    }

    public static byte[] sha1(byte[] data) {
        return DigestFun.getSha1Digest().digest(data);
    }

    public static byte[] sha1(String str) {
        return DigestFun.sha1(Fun.bytes(str));
    }

    public static String sha1Hex(byte[] data) {
        return HexFun.encodeHexString(DigestFun.sha1(data));
    }

    public static String sha1Hex(String str) {
        return HexFun.encodeHexString(DigestFun.sha1(str));
    }

    public static byte[] sha256(byte[] data) {
        return DigestFun.getSha256Digest().digest(data);
    }

    public static byte[] sha256(String str) {
        return DigestFun.sha256(Fun.bytes(str));
    }

    public static String sha256Hex(byte[] data) {
        return HexFun.encodeHexString(DigestFun.sha256(data));
    }

    public static String sha256Hex(String str) {
        return HexFun.encodeHexString(DigestFun.sha256(str));
    }

    public static byte[] sha384(byte[] data) {
        return DigestFun.getSha384Digest().digest(data);
    }

    public static byte[] sha384(String str) {
        return DigestFun.sha384(Fun.bytes(str));
    }

    public static String sha384Hex(byte[] data) {
        return HexFun.encodeHexString(DigestFun.sha384(data));
    }

    public static String sha384Hex(String str) {
        return HexFun.encodeHexString(DigestFun.sha384(str));
    }

    public static byte[] sha512(byte[] data) {
        return DigestFun.getSha512Digest().digest(data);
    }

    public static byte[] sha512(String str) {
        return DigestFun.sha512(Fun.bytes(str));
    }

    public static String sha512Hex(byte[] data) {
        return HexFun.encodeHexString(DigestFun.sha512(data));
    }

    public static String sha512Hex(String str) {
        return HexFun.encodeHexString(DigestFun.sha512(str));
    }
}

