/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparta.springwebutils.annotation.ExternalEntryPoint;
import org.sparta.springwebutils.entity.EntryPointParameter;

public final class ExternalEntryPointHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalEntryPointHelper.class);

    public static boolean isAnEntryPoint(Method method, boolean scanEntryPointAnnotation) {
        return !scanEntryPointAnnotation || scanEntryPointAnnotation && method.isAnnotationPresent(ExternalEntryPoint.class) || scanEntryPointAnnotation && method.getDeclaringClass().isAnnotationPresent(ExternalEntryPoint.class);
    }

    public static List<EntryPointParameter> getInternalEntryPointParametersRecursively(Class<?> parameterType, Set<Class<?>> typeBlacklist, Set<String> nameBlacklist, int maxDeepLevel) {
        return ExternalEntryPointHelper.getInternalEntryPointParametersRecursively(parameterType, typeBlacklist, nameBlacklist, null, 1, maxDeepLevel);
    }

    private static List<EntryPointParameter> getInternalEntryPointParametersRecursively(Class<?> parameterType, Set<Class<?>> typeBlacklist, Set<String> nameBlacklist, Field parent, int level, int maxDeepLevel) {
        ArrayList<EntryPointParameter> list = new ArrayList<EntryPointParameter>();
        for (Field field : parameterType.getDeclaredFields()) {
            field.setAccessible(true);
            if (typeBlacklist.contains(field.getType()) || nameBlacklist.contains(field.getName())) continue;
            if (ExternalEntryPointHelper.isSimpleRequestParameter(field.getType())) {
                EntryPointParameter param = new EntryPointParameter();
                param.setName(parent != null ? parent.getName() + "." + field.getName() : field.getName());
                param.setType(field.getType());
                list.add(param);
                continue;
            }
            if (ExternalEntryPointHelper.shouldWeGoDeep(field.getType()) && level < maxDeepLevel) {
                list.addAll(ExternalEntryPointHelper.getInternalEntryPointParametersRecursively(field.getType(), typeBlacklist, nameBlacklist, field, ++level, maxDeepLevel));
                continue;
            }
            LOGGER.warn("We might have reached a cycle, ignoring parameter {}", (Object)field.getName());
        }
        return list;
    }

    private static boolean shouldWeGoDeep(Class<?> type) {
        return !type.isArray() && !ClassUtils.isAssignable(type, Collection.class);
    }

    public static boolean isSimpleRequestParameter(Class<?> parameterType) {
        return ClassUtils.isPrimitiveOrWrapper(parameterType) || parameterType.isArray() && ClassUtils.isPrimitiveOrWrapper(parameterType.getComponentType()) || ClassUtils.isAssignable(parameterType, Collection.class) || ClassUtils.isAssignable(parameterType, String.class) || ClassUtils.isAssignable(parameterType, String[].class);
    }

    public static String getEntryPointDecoratedName(Method method, boolean scanEntryPointAnnotation) {
        ExternalEntryPoint externalEntryPoint;
        String decoratedName = method.getName();
        if (scanEntryPointAnnotation && method.isAnnotationPresent(ExternalEntryPoint.class) && StringUtils.isNotBlank((CharSequence)(externalEntryPoint = method.getAnnotation(ExternalEntryPoint.class)).name())) {
            decoratedName = externalEntryPoint.name();
        }
        return decoratedName;
    }

    public static Set<Class<?>> getConsolidatedTypeBlacklist(List<Class<?>> predefinedTypeBlacklist, Method method, boolean scanEntryPointAnnotation) {
        HashSet consolidatedBlacklist = new HashSet(predefinedTypeBlacklist);
        if (scanEntryPointAnnotation) {
            ExternalEntryPoint externalEntryPoint;
            if (method.getDeclaringClass().isAnnotationPresent(ExternalEntryPoint.class) && (externalEntryPoint = method.getDeclaringClass().getAnnotation(ExternalEntryPoint.class)).typeBlacklist() != null) {
                consolidatedBlacklist.addAll(Arrays.asList(externalEntryPoint.typeBlacklist()));
            }
            if (method.isAnnotationPresent(ExternalEntryPoint.class) && (externalEntryPoint = method.getAnnotation(ExternalEntryPoint.class)).typeBlacklist() != null) {
                consolidatedBlacklist.addAll(Arrays.asList(externalEntryPoint.typeBlacklist()));
            }
        }
        return consolidatedBlacklist;
    }

    public static Set<String> getConsolidatedNameBlacklist(List<String> predefinedNameBlacklist, Method method, boolean scanEntryPointAnnotation) {
        HashSet<String> consolidatedBlacklist = new HashSet<String>(predefinedNameBlacklist);
        if (scanEntryPointAnnotation) {
            ExternalEntryPoint externalEntryPoint;
            if (method.getDeclaringClass().isAnnotationPresent(ExternalEntryPoint.class) && (externalEntryPoint = method.getDeclaringClass().getAnnotation(ExternalEntryPoint.class)).nameBlacklist() != null) {
                consolidatedBlacklist.addAll(Arrays.asList(externalEntryPoint.nameBlacklist()));
            }
            if (method.isAnnotationPresent(ExternalEntryPoint.class) && (externalEntryPoint = method.getAnnotation(ExternalEntryPoint.class)).nameBlacklist() != null) {
                consolidatedBlacklist.addAll(Arrays.asList(externalEntryPoint.nameBlacklist()));
            }
        }
        return consolidatedBlacklist;
    }
}

