/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparta.springwebutils.annotation.QueryWhereClause;
import org.sparta.springwebutils.annotation.QueryWhereClauses;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class QueryWhereClauseBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryWhereClauseBuilder.class);
    static final Pattern PARAM_PATTERN = Pattern.compile("\\{(.*?)\\}", 40);

    public static String buildWhereClause(Object object, MapSqlParameterSource params) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        LOGGER.debug("Building query");
        StringBuilder query = new StringBuilder();
        boolean first = true;
        for (Field field : object.getClass().getDeclaredFields()) {
            QueryWhereClause[] annotations;
            if (!field.isAnnotationPresent(QueryWhereClause.class) && !field.isAnnotationPresent(QueryWhereClauses.class)) continue;
            String fieldName = field.getName();
            LOGGER.trace("New annotated field found: {}", (Object)fieldName);
            for (QueryWhereClause annotation : annotations = (QueryWhereClause[])field.getAnnotationsByType(QueryWhereClause.class)) {
                String whereValue = annotation.value();
                int[] types = annotation.fieldTypes();
                int index = 0;
                LOGGER.trace("Unprocessed whereClause: {}", (Object)whereValue);
                Matcher matcher = PARAM_PATTERN.matcher(whereValue);
                boolean hasValue = false;
                while (matcher.find()) {
                    String originalParam = matcher.group(1);
                    LOGGER.debug("New parameter found in the query: {}", (Object)originalParam);
                    String convertedParam = originalParam.replaceAll("this", fieldName);
                    String value = null;
                    try {
                        value = BeanUtils.getNestedProperty((Object)object, (String)convertedParam);
                    }
                    catch (NestedNullException e) {
                        LOGGER.info("Bean not accessible= {}", (Object)e.getMessage());
                    }
                    if (value == null) {
                        LOGGER.debug("Param {} was null, ignoring in the query", (Object)convertedParam);
                    } else {
                        hasValue = true;
                        whereValue = StringUtils.replace((String)whereValue, (String)("{" + originalParam + "}"), (String)(":" + convertedParam));
                        if (params != null) {
                            if (index <= types.length - 1) {
                                params.addValue(convertedParam, (Object)value, types[index]);
                            } else {
                                params.addValue(convertedParam, (Object)value);
                            }
                        }
                    }
                    ++index;
                }
                if (!hasValue) continue;
                if (!first) {
                    query.append(" AND ");
                } else {
                    first = false;
                }
                query.append(whereValue);
            }
        }
        LOGGER.debug("built query={}", (Object)query);
        return query.toString();
    }
}

