/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.property;

import java.util.Properties;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class PropertiesLoaderBuilder {
    private AbstractEnvironment env;
    private Properties props;

    PropertiesLoaderBuilder(AbstractEnvironment env) {
        this.env = env;
        this.props = new Properties();
    }

    public PropertiesLoaderBuilder loadProperty(String name) {
        if (this.env.containsProperty(name)) {
            this.props.put(name, this.env.getProperty(name));
        }
        return this;
    }

    public PropertiesLoaderBuilder addProperty(String name, String value) {
        this.props.put(name, value);
        return this;
    }

    public PropertiesLoaderBuilder loadPropertiesByPrefix(String prefix) {
        return this.loadPropertiesByPrefix(prefix, false);
    }

    public PropertiesLoaderBuilder loadPropertiesByPrefix(String prefix, boolean removePrefix) {
        for (PropertySource propertySource : this.env.getPropertySources()) {
            if (!(propertySource instanceof MapPropertySource)) continue;
            MapPropertySource mapPropSource = (MapPropertySource)propertySource;
            for (String propName : mapPropSource.getPropertyNames()) {
                if (!propName.startsWith(prefix) || this.props.containsKey(propName)) continue;
                String adjustedName = propName;
                if (removePrefix) {
                    adjustedName = propName.substring(prefix.length(), propName.length());
                }
                this.props.put(adjustedName, this.env.getProperty(propName));
            }
        }
        return this;
    }

    public PropertiesLoaderBuilder loadAllPropertiesFromSpring() {
        for (PropertySource propertySource : this.env.getPropertySources()) {
            if (!(propertySource instanceof MapPropertySource)) continue;
            MapPropertySource mapPropSource = (MapPropertySource)propertySource;
            for (String propName : mapPropSource.getPropertyNames()) {
                if (this.props.containsKey(propName)) continue;
                this.props.put(propName, this.env.getProperty(propName));
            }
        }
        return this;
    }

    public Properties build() {
        return this.props;
    }
}

