/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.queryloader.impl;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.sparta.springwebutils.queryloader.QueryLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class FileQueryLoader
implements QueryLoader,
InitializingBean {
    private static final ConcurrentMap<String, String> QUERY_CACHE = new ConcurrentHashMap<String, String>(50);
    private String scriptsFolder;

    public FileQueryLoader(String scriptsFolder) {
        this.scriptsFolder = StringUtils.appendIfMissing((String)scriptsFolder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    @Override
    public String load(String queryName) {
        if (!QUERY_CACHE.containsKey(queryName)) {
            QUERY_CACHE.put(queryName, this.loadfromFromFile(queryName));
        }
        return (String)QUERY_CACHE.get(queryName);
    }

    @Override
    public String[] loadMultiple(String queryName, char separator) {
        String fullSql = this.load(queryName);
        return StringUtils.split((String)fullSql, (char)separator);
    }

    private String loadfromFromFile(String queryName) throws IllegalStateException {
        String string;
        block9: {
            InputStream is = this.getClass().getResourceAsStream(this.scriptsFolder + queryName + ".sql");
            try {
                String sql = StringUtils.join((Iterable)IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8), (String)IOUtils.LINE_SEPARATOR);
                String[] tokens = StringUtils.substringsBetween((String)sql, (String)"${", (String)"}");
                if (tokens != null && tokens.length > 0) {
                    Map values = Arrays.stream(tokens).collect(Collectors.toMap(Function.identity(), this::load, (o, n) -> o));
                    sql = StrSubstitutor.replace((Object)sql, values);
                }
                string = sql;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not load query " + this.scriptsFolder + queryName, e);
                }
            }
            is.close();
        }
        return string;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.scriptsFolder, (String)"scriptsFolder cannot be null");
    }
}

