/*
 * Decompiled with CFR 0.152.
 */
package cz.advel.stack.instrument;

import cz.advel.stack.instrument.Instrumenter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class InstrumentationTask
extends Task {
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private File destDir;
    private String stackPackageName;
    private boolean disabled = false;
    private boolean singleThread = false;
    private boolean isolated = false;

    public void addFileSet(FileSet fs) {
        this.fileSets.add(fs);
    }

    public void setDest(File destDir) {
        this.destDir = destDir;
    }

    public void setPackageName(String packageName) {
        this.stackPackageName = packageName;
    }

    public void setDisabled(boolean b) {
        this.disabled = b;
    }

    public void setSingleThread(boolean b) {
        this.singleThread = b;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public void execute() throws BuildException {
        try {
            ArrayList<File> files = new ArrayList<File>();
            for (FileSet fs : this.fileSets) {
                String[] fileNames;
                for (String fname : fileNames = fs.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                    File file = new File(fs.getDir(this.getProject()), fname);
                    if (!file.getName().endsWith(".class")) continue;
                    files.add(file);
                }
            }
            Instrumenter instr = new Instrumenter(files, this.destDir, this.stackPackageName);
            instr.setDisabled(this.disabled);
            instr.setSingleThread(this.singleThread);
            instr.setIsolated(this.isolated);
            instr.process();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

