/*
 * Decompiled with CFR 0.152.
 */
package ace.data.player;

import ace.core.errors.IllegalPlayerDataException;
import ace.core.events.AttributesInitiatedEvent;
import ace.core.events.DataLayerInitiatedEvent;
import ace.data.player.IPlayerData;
import ace.data.player.attributes.IAttributesData;
import ace.database.IDataContentRepository;
import ace.database.entities.content.IntContent;
import ace.database.entities.content.UTF16Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class PlayerData
implements IPlayerData {
    private static final Logger log = LoggerFactory.getLogger(PlayerData.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private IDataContentRepository contentRepository;
    @Autowired
    IAttributesData attributeData;
    @Value(value="${editor.player.min.level}")
    private int minLevel;
    @Value(value="${editor.player.max.level}")
    private int maxLevel;
    @Value(value="${editor.player.skills.per.level}")
    private int skillsPerLevel;
    @Value(value="${editor.player.attributes.per.level}")
    private int attributesPerLevel;
    private UTF16Content playerName;
    private IntContent money;
    private IntContent unspentSkillPoints;
    private IntContent playerLevel;

    @EventListener
    public void onDatabaseInitiatedEvent(AttributesInitiatedEvent event) {
        this.playerName = (UTF16Content)this.contentRepository.findByVariableName("myPlayerName");
        this.money = (IntContent)this.contentRepository.findByVariableName("money");
        this.unspentSkillPoints = (IntContent)this.contentRepository.findByVariableName("skillPoints");
        this.playerLevel = (IntContent)this.contentRepository.findByVariableName("currentStats.charLevel");
        this.eventPublisher.publishEvent((ApplicationEvent)new DataLayerInitiatedEvent(this));
        log.info("Data layer initiated");
    }

    @Override
    public String getPlayerName() {
        return this.playerName.getDataContent();
    }

    @Override
    public void setPlayerName(String playerName) {
        this.playerName.setDataContent(playerName);
        this.contentRepository.saveAndFlush(this.playerName);
    }

    @Override
    public Integer getMoney() {
        return this.money.getDataContent();
    }

    @Override
    public void setMoney(Integer money) throws IllegalPlayerDataException {
        if (money < 0) {
            log.error("Could not set money to {}, money must be a positive amount", (Object)money);
            throw new IllegalPlayerDataException("Money amount can not be a negative amount");
        }
        this.money.setDataContent(money);
        this.contentRepository.saveAndFlush(this.money);
    }

    @Override
    public Integer getPlayerLevel() {
        return this.playerLevel.getDataContent();
    }

    @Override
    public void setPlayerLevel(Integer newLevel) throws IllegalPlayerDataException {
        int levelDiff = newLevel - this.getPlayerLevel();
        int newSkillPoints = this.getUnspentSkillPoints() + levelDiff * this.skillsPerLevel;
        int newAttributePoints = this.attributeData.getUnspentAttributePoints() + levelDiff * this.attributesPerLevel;
        if (newLevel < this.minLevel || newLevel > this.maxLevel) {
            log.error("Could not set player level to {}, player level must be between {} and {}", new Object[]{newLevel, this.minLevel, this.maxLevel});
            throw new IllegalPlayerDataException("Illegal player level");
        }
        if (newSkillPoints < 0 || newAttributePoints < 0) {
            log.error("Could not set player level to {}", (Object)newLevel);
            throw new IllegalPlayerDataException("Invalid modification of player level");
        }
        this.playerLevel.setDataContent(newLevel);
        this.setUnspentSkillPoints(newSkillPoints);
        this.attributeData.setUnspentAttributePoints(newAttributePoints);
        this.contentRepository.saveAndFlush(this.playerLevel);
    }

    @Override
    public Integer getUnspentSkillPoints() {
        return this.unspentSkillPoints.getDataContent();
    }

    @Override
    public void setUnspentSkillPoints(Integer skillPoints) throws IllegalPlayerDataException {
        if (skillPoints < 0) {
            log.error("Could not set skill points to {}, skill points must be a positive amount", (Object)skillPoints);
            throw new IllegalPlayerDataException("Skill points can not be a negative amount");
        }
        this.unspentSkillPoints.setDataContent(skillPoints);
        this.contentRepository.saveAndFlush(this.unspentSkillPoints);
    }
}

