/*
 * Decompiled with CFR 0.152.
 */
package ace.data.player.attributes;

import ace.Utils;
import ace.core.errors.IllegalPlayerDataException;
import ace.core.events.AttributesInitiatedEvent;
import ace.core.events.DatabaseInitiatedEvent;
import ace.data.player.attributes.IAttributesData;
import ace.database.IDataContentRepository;
import ace.database.entities.content.FloatContent;
import ace.database.entities.content.IntContent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class AttributesData
implements IAttributesData {
    private static final Logger log = LoggerFactory.getLogger(AttributesData.class);
    private static final Integer CHARACTERISTIC_GAIN = 4;
    private static final Integer FLUID_GAIN = CHARACTERISTIC_GAIN * 10;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private IDataContentRepository contentRepository;
    @Value(value="${editor.player.min.characteristic}")
    private int minCharacteristic;
    @Value(value="${editor.player.min.fluid}")
    private int minFluid;
    private IntContent unspentAttributePoints;
    private FloatContent strengthAttribute;
    private FloatContent dexterityAttribute;
    private FloatContent intelligenceAttribute;
    private FloatContent healthAttribute;
    private FloatContent manaAttribute;

    @EventListener
    public void onDatabaseInitiatedEvent(DatabaseInitiatedEvent event) {
        this.unspentAttributePoints = (IntContent)this.contentRepository.findByVariableName("modifierPoints");
        List list = Utils.listFindSequence(this.contentRepository.findAllByVariableName("temp"), 5);
        this.strengthAttribute = (FloatContent)list.get(0);
        this.dexterityAttribute = (FloatContent)list.get(1);
        this.intelligenceAttribute = (FloatContent)list.get(2);
        this.healthAttribute = (FloatContent)list.get(3);
        this.manaAttribute = (FloatContent)list.get(4);
        this.eventPublisher.publishEvent((ApplicationEvent)new AttributesInitiatedEvent(this));
        log.info("Attributes initiated");
    }

    @Override
    public Integer getCharacteristicGain() {
        return CHARACTERISTIC_GAIN;
    }

    @Override
    public Integer getFluidGain() {
        return FLUID_GAIN;
    }

    @Override
    public Integer getUnspentAttributePoints() {
        return this.unspentAttributePoints.getDataContent();
    }

    @Override
    public void setUnspentAttributePoints(Integer attributePoints) throws IllegalPlayerDataException {
        if (attributePoints < 0) {
            log.error("Could not set attribute points to {}, attribute points must be a positive amount", (Object)attributePoints);
            throw new IllegalPlayerDataException("Unspent attribute points can not be less than zero");
        }
        this.unspentAttributePoints.setDataContent(attributePoints);
        this.contentRepository.saveAndFlush(this.unspentAttributePoints);
    }

    @Override
    public void resetAllAttributes() {
        int unspentPoints = this.getUnspentAttributePoints();
        unspentPoints += (this.getStrengthAttribute() - this.minCharacteristic) / CHARACTERISTIC_GAIN;
        unspentPoints += (this.getDexterityAttribute() - this.minCharacteristic) / CHARACTERISTIC_GAIN;
        unspentPoints += (this.getIntelligenceAttribute() - this.minCharacteristic) / CHARACTERISTIC_GAIN;
        unspentPoints += (this.getHealthAttribute() - this.minFluid) / FLUID_GAIN;
        unspentPoints += (this.getManaAttribute() - this.minFluid) / FLUID_GAIN;
        try {
            this.setStrengthAttribute(this.minCharacteristic);
            this.setDexterityAttribute(this.minCharacteristic);
            this.setIntelligenceAttribute(this.minCharacteristic);
            this.setHealthAttribute(this.minFluid);
            this.setManaAttribute(this.minFluid);
            this.setUnspentAttributePoints(unspentPoints);
        }
        catch (IllegalPlayerDataException e) {
            log.error("Something went horrible wrong, check trace!");
            e.printStackTrace();
        }
    }

    @Override
    public Integer getStrengthAttribute() {
        return this.strengthAttribute.getDataContent().intValue();
    }

    @Override
    public void setStrengthAttribute(Integer attributePoints) throws IllegalPlayerDataException {
        this.calculateUnspentCharacteristicPoints("Strength", this.getStrengthAttribute(), attributePoints);
        this.strengthAttribute.setDataContent(Float.valueOf(attributePoints.intValue()));
        this.contentRepository.saveAndFlush(this.strengthAttribute);
    }

    @Override
    public Integer getDexterityAttribute() {
        return this.dexterityAttribute.getDataContent().intValue();
    }

    @Override
    public void setDexterityAttribute(Integer attributePoints) throws IllegalPlayerDataException {
        this.calculateUnspentCharacteristicPoints("Dexterity", this.getDexterityAttribute(), attributePoints);
        this.dexterityAttribute.setDataContent(Float.valueOf(attributePoints.intValue()));
        this.contentRepository.saveAndFlush(this.dexterityAttribute);
    }

    @Override
    public Integer getIntelligenceAttribute() {
        return this.intelligenceAttribute.getDataContent().intValue();
    }

    @Override
    public void setIntelligenceAttribute(Integer attributePoints) throws IllegalPlayerDataException {
        this.calculateUnspentCharacteristicPoints("Intelligence", this.getIntelligenceAttribute(), attributePoints);
        this.intelligenceAttribute.setDataContent(Float.valueOf(attributePoints.intValue()));
        this.contentRepository.saveAndFlush(this.intelligenceAttribute);
    }

    @Override
    public Integer getHealthAttribute() {
        return this.healthAttribute.getDataContent().intValue();
    }

    @Override
    public void setHealthAttribute(Integer attributePoints) throws IllegalPlayerDataException {
        this.calculateUnspentFluidPoints("Health", this.getHealthAttribute(), attributePoints);
        this.healthAttribute.setDataContent(Float.valueOf(attributePoints.intValue()));
        this.contentRepository.saveAndFlush(this.healthAttribute);
    }

    @Override
    public Integer getManaAttribute() {
        return this.manaAttribute.getDataContent().intValue();
    }

    @Override
    public void setManaAttribute(Integer attributePoints) throws IllegalPlayerDataException {
        this.calculateUnspentFluidPoints("Mana", this.getManaAttribute(), attributePoints);
        this.manaAttribute.setDataContent(Float.valueOf(attributePoints.intValue()));
        this.contentRepository.saveAndFlush(this.manaAttribute);
    }

    private void calculateUnspentCharacteristicPoints(String attributeName, int currentValue, int newValue) throws IllegalPlayerDataException {
        if (newValue < this.minCharacteristic) {
            log.error("Could not set {} to {}, attribute must be greater than {}", new Object[]{attributeName, newValue, this.minCharacteristic});
            throw new IllegalPlayerDataException(attributeName + " can not be less than " + this.minCharacteristic);
        }
        int points = (newValue - currentValue) / CHARACTERISTIC_GAIN;
        this.setUnspentAttributePoints(this.getUnspentAttributePoints() - points);
    }

    private void calculateUnspentFluidPoints(String attributeName, int currentValue, int newValue) throws IllegalPlayerDataException {
        if (newValue < this.minFluid) {
            log.error("Could not set {} to {}, attribute must be greater than {}", new Object[]{attributeName, newValue, this.minFluid});
            throw new IllegalPlayerDataException(attributeName + " can not be less than " + this.minFluid);
        }
        int points = (newValue - currentValue) / FLUID_GAIN;
        this.setUnspentAttributePoints(this.getUnspentAttributePoints() - points);
    }
}

