/*
 * Decompiled with CFR 0.152.
 */
package ace.ui;

import ace.core.events.DataLayerInitiatedEvent;
import ace.core.events.FailedToLoadFileEvent;
import ace.data.file.handling.IFileHandler;
import ace.ui.components.ContentPanel;
import ace.ui.dialogs.WaitDialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.nio.ByteBuffer;
import javax.annotation.PostConstruct;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"editor.live.boot"})
public class ApplicationWindow {
    @Value(value="classpath:ui/ApplicationIcon.png")
    private Resource applicationIcon;
    @Autowired
    IFileHandler<ByteBuffer> fileHandler;
    @Autowired
    private ContentPanel contentPanel;
    private JFrame frame;
    private JFileChooser fileChooser;
    private WaitDialog waitDialog;

    @PostConstruct
    public void init() {
        this.createFrame();
        this.createFileChooser();
        this.createMenu();
        this.waitDialog = new WaitDialog(this.frame);
        this.frame.setVisible(true);
    }

    @EventListener
    public void onDatabaseInitiatedEvent(DataLayerInitiatedEvent event) {
        this.frame.setContentPane(this.contentPanel);
        this.waitDialog.closeWaitDialog();
    }

    @EventListener
    public void onFailedToLoadFileEvent(FailedToLoadFileEvent event) {
        this.frame.setContentPane(new JPanel());
        this.waitDialog.closeWaitDialog();
        JOptionPane.showMessageDialog(this.frame, "Could not load file, either the file is corrupt or is not supported", "Failed to load file", 0);
    }

    private void createFrame() {
        this.frame = new JFrame("ARPG Character Editor");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(500, 500);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(dim.width / 2 - this.frame.getSize().width / 2, dim.height / 2 - this.frame.getSize().height / 2);
        this.configureFrame();
    }

    private void configureFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            ImageIcon frameIcon = new ImageIcon(this.applicationIcon.getURL());
            this.frame.setIconImage(frameIcon.getImage());
            SwingUtilities.updateComponentTreeUI(this.frame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createFileChooser() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(0);
    }

    private void createMenu() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem item = new JMenuItem("Open File");
        item.addActionListener(event -> this.openFileChooser());
        menu.add(item);
        item = new JMenuItem("Save File");
        item.addActionListener(event -> this.saveFileChooser());
        menu.add(item);
        item = new JMenuItem("Exit");
        item.addActionListener(event -> System.exit(0));
        menu.add(item);
        this.frame.setJMenuBar(menuBar);
    }

    private void openFileChooser() {
        if (this.fileChooser.showOpenDialog(this.frame) != 1) {
            this.waitDialog.showWaitDialog("Parsing file, please wait...");
            this.fileHandler.loadFile(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void saveFileChooser() {
        if (this.fileChooser.showSaveDialog(this.frame) != 1) {
            this.waitDialog.showWaitDialog("Saving file, please wait...");
            this.fileHandler.saveFile(this.fileChooser.getSelectedFile().getAbsolutePath());
            this.waitDialog.closeWaitDialog();
        }
    }
}

