/*
 * Decompiled with CFR 0.152.
 */
package ace.ui.components;

import ace.core.events.DataLayerInitiatedEvent;
import ace.ui.components.panels.CharacterPanel;
import ace.ui.components.panels.CheatPanel;
import java.awt.GridLayout;
import javax.annotation.PostConstruct;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"editor.live.boot"})
public class ContentPanel
extends JPanel {
    @Autowired
    private CharacterPanel characterPanel;
    @Autowired
    private CheatPanel cheatPanel;
    private JTabbedPane sidebar;

    @PostConstruct
    private void init() {
        this.setLayout(new GridLayout());
        this.sidebar = new JTabbedPane(2);
        this.sidebar.addTab("Character", this.characterPanel);
        this.sidebar.addTab("Skills", new JPanel());
        this.sidebar.addTab("Cheats", this.cheatPanel);
    }

    @EventListener
    public void onDatabaseInitiatedEvent(DataLayerInitiatedEvent event) {
        this.removeAll();
        try {
            this.characterPanel.renderData();
            this.cheatPanel.renderData();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.add(this.sidebar);
        this.revalidate();
    }
}

