/*
 * Decompiled with CFR 0.152.
 */
package ace.ui.components.panels;

import ace.data.player.IPlayerData;
import ace.data.player.attributes.IAttributesData;
import ace.ui.components.partial.spinner.SpinnerDataPanel;
import ace.ui.components.partial.text.field.TextFormattedDataPanel;
import ace.ui.utils.GridBagUtil;
import ace.ui.utils.builders.GridBagConstraintsBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.annotation.PostConstruct;
import javax.swing.JPanel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"editor.live.boot"})
public class CheatPanel
extends JPanel {
    @Autowired
    private IPlayerData playerData;
    @Autowired
    private IAttributesData attributesData;
    private SpinnerDataPanel playerLevel;
    private TextFormattedDataPanel<Integer> money;
    private SpinnerDataPanel unspentSkillPoints;
    private SpinnerDataPanel unspentAttributePoints;

    @PostConstruct
    private void init() {
        this.setLayout(new GridBagLayout());
    }

    public void renderData() throws NoSuchMethodException {
        this.removeAll();
        GridBagConstraints c = new GridBagConstraintsBuilder().withFill(2).withWeightX(1).build();
        Class<?> playerClass = this.playerData.getClass();
        Class<?> attributesClass = this.attributesData.getClass();
        this.playerLevel = new SpinnerDataPanel("Player level", this.playerData.getPlayerLevel(), 0, 1);
        this.playerLevel.setDataGetter(this.playerData, playerClass.getMethod("getPlayerLevel", new Class[0]));
        this.playerLevel.createListener(this.playerData, playerClass.getMethod("setPlayerLevel", Integer.class));
        GridBagUtil.addComponentWithConstraints(this, this.playerLevel, 0, 0, c);
        this.money = new TextFormattedDataPanel<Integer>("Money", this.playerData.getMoney());
        this.money.setDataGetter(this.playerData, playerClass.getMethod("getMoney", new Class[0]));
        this.money.createListener(this.playerData, playerClass.getMethod("setMoney", Integer.class));
        GridBagUtil.addComponentWithConstraints(this, this.money, 0, 1, c);
        this.unspentSkillPoints = new SpinnerDataPanel("Unspent skill points", this.playerData.getUnspentSkillPoints(), 0, 1);
        this.unspentSkillPoints.setDataGetter(this.playerData, playerClass.getMethod("getUnspentSkillPoints", new Class[0]));
        this.unspentSkillPoints.createListener(this.playerData, playerClass.getMethod("setUnspentSkillPoints", Integer.class));
        GridBagUtil.addComponentWithConstraints(this, this.unspentSkillPoints, 0, 2, c);
        this.unspentAttributePoints = new SpinnerDataPanel("Unspent attribute points", this.attributesData.getUnspentAttributePoints(), 0, 1);
        this.unspentAttributePoints.setDataGetter(this.attributesData, attributesClass.getMethod("getUnspentAttributePoints", new Class[0]));
        this.unspentAttributePoints.createListener(this.attributesData, attributesClass.getMethod("setUnspentAttributePoints", Integer.class));
        GridBagUtil.addComponentWithConstraints(this, this.unspentAttributePoints, 0, 3, c);
    }
}

