/*
 * Decompiled with CFR 0.152.
 */
package ace.ui.components.panels.sub;

import ace.data.player.attributes.IAttributesData;
import ace.ui.components.partial.ADataPanel;
import ace.ui.components.partial.spinner.SpinnerDataPanel;
import ace.ui.components.partial.text.field.TextReadOnlyDataPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.annotation.PostConstruct;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@org.springframework.stereotype.Component
@ConditionalOnProperty(name={"editor.live.boot"})
public class AttributesPanel
extends JPanel {
    @Autowired
    private IAttributesData attributesData;
    private SpinnerDataPanel strengthAttribute;
    private SpinnerDataPanel dexterityAttribute;
    private SpinnerDataPanel intelligenceAttribute;
    private SpinnerDataPanel healthAttribute;
    private SpinnerDataPanel manaAttribute;
    private TextReadOnlyDataPanel<Integer> unspentAttributePoints;
    private JButton resetAttributes;

    @PostConstruct
    private void init() {
        this.setLayout(new GridLayout(0, 1));
    }

    public void renderData() throws NoSuchMethodException {
        this.removeAll();
        this.createAttributesPanel();
    }

    private void createAttributesPanel() throws NoSuchMethodException {
        int charStep = this.attributesData.getCharacteristicGain();
        int fluidStep = this.attributesData.getFluidGain();
        Class<?> clazz = this.attributesData.getClass();
        this.strengthAttribute = new SpinnerDataPanel("Strength", this.attributesData.getStrengthAttribute(), 0, charStep);
        this.strengthAttribute.setDataGetter(this.attributesData, clazz.getMethod("getStrengthAttribute", new Class[0]));
        this.strengthAttribute.createListener(this.attributesData, clazz.getMethod("setStrengthAttribute", Integer.class));
        this.add(this.strengthAttribute);
        this.dexterityAttribute = new SpinnerDataPanel("Dexterity", this.attributesData.getDexterityAttribute(), 0, charStep);
        this.dexterityAttribute.setDataGetter(this.attributesData, clazz.getMethod("getDexterityAttribute", new Class[0]));
        this.dexterityAttribute.createListener(this.attributesData, clazz.getMethod("setDexterityAttribute", Integer.class));
        this.add(this.dexterityAttribute);
        this.intelligenceAttribute = new SpinnerDataPanel("Intelligence", this.attributesData.getIntelligenceAttribute(), 0, charStep);
        this.intelligenceAttribute.setDataGetter(this.attributesData, clazz.getMethod("getIntelligenceAttribute", new Class[0]));
        this.intelligenceAttribute.createListener(this.attributesData, clazz.getMethod("setIntelligenceAttribute", Integer.class));
        this.add(this.intelligenceAttribute);
        this.healthAttribute = new SpinnerDataPanel("Health", this.attributesData.getHealthAttribute(), 0, fluidStep);
        this.healthAttribute.setDataGetter(this.attributesData, clazz.getMethod("getHealthAttribute", new Class[0]));
        this.healthAttribute.createListener(this.attributesData, clazz.getMethod("setHealthAttribute", Integer.class));
        this.add(this.healthAttribute);
        this.manaAttribute = new SpinnerDataPanel("Mana", this.attributesData.getManaAttribute(), 0, fluidStep);
        this.manaAttribute.setDataGetter(this.attributesData, clazz.getMethod("getManaAttribute", new Class[0]));
        this.manaAttribute.createListener(this.attributesData, clazz.getMethod("setManaAttribute", Integer.class));
        this.add(this.manaAttribute);
        this.unspentAttributePoints = new TextReadOnlyDataPanel<Integer>("Unspent points", this.attributesData.getUnspentAttributePoints());
        this.unspentAttributePoints.setDataGetter(this.attributesData, clazz.getMethod("getUnspentAttributePoints", new Class[0]));
        this.add(this.unspentAttributePoints);
        this.resetAttributes = new JButton("Reset");
        this.resetAttributes.addActionListener(e -> {
            this.attributesData.resetAllAttributes();
            JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this.resetAttributes);
            this.reloadAllData(frame.getContentPane());
        });
        this.add(this.resetAttributes);
    }

    private void reloadAllData(Container c) {
        for (Component comp : c.getComponents()) {
            if (comp instanceof ADataPanel) {
                ((ADataPanel)comp).reloadData();
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.reloadAllData((Container)comp);
        }
    }
}

