/*
 * Decompiled with CFR 0.152.
 */
package ace.ui.components.panels.sub;

import ace.data.player.IPlayerData;
import ace.ui.components.partial.text.field.TextFormattedDataPanel;
import ace.ui.components.partial.text.field.TextReadOnlyDataPanel;
import java.awt.GridLayout;
import javax.annotation.PostConstruct;
import javax.swing.JPanel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"editor.live.boot"})
public class GeneralPanel
extends JPanel {
    @Autowired
    private IPlayerData playerData;
    private TextFormattedDataPanel<String> playerName;
    private TextReadOnlyDataPanel<Integer> playerLevel;
    private TextReadOnlyDataPanel<Integer> money;
    private TextReadOnlyDataPanel<Integer> unspentSkillPoints;

    @PostConstruct
    private void init() {
        this.setLayout(new GridLayout(0, 1));
    }

    public void renderData() throws NoSuchMethodException {
        this.removeAll();
        this.createGeneralPanel();
    }

    private void createGeneralPanel() throws NoSuchMethodException {
        Class<?> clazz = this.playerData.getClass();
        this.playerName = new TextFormattedDataPanel<String>("Character name", this.playerData.getPlayerName());
        this.playerName.setDataGetter(this.playerData, clazz.getMethod("getPlayerName", new Class[0]));
        this.playerName.createListener(this.playerData, clazz.getMethod("setPlayerName", String.class));
        this.add(this.playerName);
        this.playerLevel = new TextReadOnlyDataPanel<Integer>("Player level", this.playerData.getPlayerLevel());
        this.playerLevel.setDataGetter(this.playerData, clazz.getMethod("getPlayerLevel", new Class[0]));
        this.add(this.playerLevel);
        this.money = new TextReadOnlyDataPanel<Integer>("Money", this.playerData.getMoney());
        this.money.setDataGetter(this.playerData, clazz.getMethod("getMoney", new Class[0]));
        this.add(this.money);
        this.unspentSkillPoints = new TextReadOnlyDataPanel<Integer>("Unspent skill points", this.playerData.getUnspentSkillPoints());
        this.unspentSkillPoints.setDataGetter(this.playerData, clazz.getMethod("getUnspentSkillPoints", new Class[0]));
        this.add(this.unspentSkillPoints);
    }
}

