/*
 * Decompiled with CFR 0.152.
 */
package ace.ui.components.partial;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ADataPanel<T, V extends JComponent>
extends JPanel {
    protected V variableValueContainer;
    private static final Logger log = LoggerFactory.getLogger(ADataPanel.class);
    private final Label variableName;
    private Object instance;
    private Method method;

    public ADataPanel(String name) {
        this.setLayout(new GridLayout(1, 0));
        this.variableName = new Label(name);
        this.add(this.variableName);
    }

    public void setDataGetter(Object instance, Method method) {
        this.instance = instance;
        this.method = method;
    }

    public void reloadData() {
        log.debug("Getting value from method {}", (Object)this.method.getName());
        Object fetchedValue = this.executeMethod(this.instance, this.method, null);
        this.setData(fetchedValue);
    }

    protected Object executeMethod(Object instance, Method method, Object args) {
        try {
            if (args == null) {
                return method.invoke(instance, new Object[0]);
            }
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            this.exceptionHandling(e);
            return null;
        }
    }

    protected abstract void setData(T var1);

    protected void updateAllVariableRows(Container c) {
        for (Component comp : c.getComponents()) {
            if (comp instanceof ADataPanel) {
                ((ADataPanel)comp).reloadData();
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.updateAllVariableRows((Container)comp);
        }
    }

    private void exceptionHandling(Exception e) {
        String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.toString();
        JOptionPane.showMessageDialog(this, errorMessage, "Invalid Data", 0);
    }
}

