/*
 * Decompiled with CFR 0.152.
 */
package ace.ui.components.partial.spinner;

import ace.ui.components.partial.ADataPanel;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinnerDataPanel
extends ADataPanel<Integer, JSpinner> {
    private static final Logger log = LoggerFactory.getLogger(SpinnerDataPanel.class);

    public SpinnerDataPanel(String name, Integer variableValue, int minValue, int stepSize) {
        super(name);
        this.variableValueContainer = new JSpinner(new SpinnerNumberModel(variableValue, minValue, Integer.MAX_VALUE, stepSize));
        ((JSpinner.DefaultEditor)((JSpinner)this.variableValueContainer).getEditor()).getTextField().setEditable(false);
        this.add(this.variableValueContainer);
    }

    public void createListener(Object instance, Method method) {
        ((JSpinner)this.variableValueContainer).addChangeListener(e -> {
            log.debug("Setting value {} for method {}", ((JSpinner)this.variableValueContainer).getValue(), (Object)method.getName());
            this.executeMethod(instance, method, ((JSpinner)this.variableValueContainer).getValue());
            JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this.variableValueContainer);
            this.updateAllVariableRows(frame.getContentPane());
        });
    }

    @Override
    protected void setData(Integer value) {
        ((JSpinner)this.variableValueContainer).setValue(value);
    }
}

