/*
 * Decompiled with CFR 0.152.
 */
package ace.ui.utils.builders;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class GridBagConstraintsBuilder {
    private final GridBagConstraints constraints = new GridBagConstraints();

    public GridBagConstraintsBuilder withGridHeight(int gridHeight) {
        this.constraints.gridheight = gridHeight;
        return this;
    }

    public GridBagConstraintsBuilder withGridWidth(int gridWidth) {
        this.constraints.gridwidth = gridWidth;
        return this;
    }

    public GridBagConstraintsBuilder withFill(int fill) {
        this.constraints.fill = fill;
        return this;
    }

    public GridBagConstraintsBuilder withDefaultPadding() {
        this.constraints.insets = new Insets(10, 10, 10, 10);
        return this;
    }

    public GridBagConstraintsBuilder withDefaultWidthPadding() {
        this.constraints.insets = new Insets(0, 10, 0, 10);
        return this;
    }

    public GridBagConstraintsBuilder withDefaultHeightPadding() {
        this.constraints.insets = new Insets(10, 0, 10, 0);
        return this;
    }

    public GridBagConstraintsBuilder withWeightX(int weightX) {
        this.constraints.weightx = weightX;
        return this;
    }

    public GridBagConstraintsBuilder withWeightY(int weightY) {
        this.constraints.weighty = weightY;
        return this;
    }

    public GridBagConstraintsBuilder withFillOutWeight() {
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        return this;
    }

    public GridBagConstraints build() {
        return this.constraints;
    }
}

