/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlogging;

import com.github.structlogging.AuditContext;
import com.github.structlogging.LoggingCallback;
import com.github.structlogging.LoggingEvent;
import com.github.structlogging.StructLogger;
import com.github.structlogging.annotation.LoggerContext;
import com.github.structlogging.kafka.EventTypeAwareKafkaCallback;
import com.github.structlogging.kafka.LoggingEventJsonSerializer;
import com.github.structlogging.utils.SidCounter;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.LongSerializer;

public class KafkaExample {
    @LoggerContext(context=AuditContext.class)
    private static StructLogger<AuditContext> logger = new StructLogger((LoggingCallback)new EventTypeAwareKafkaCallback(KafkaExample.createProducer("localhost:9092")));

    public static void main(String[] args) {
        logger.auditEvent((LoggingEvent)new StartAction("start action", "com.github.structlogging.KafkaExample", 52L, "StartAction", SidCounter.incrementAndGet(), "AUDIT", 1L));
        logger.auditEvent((LoggingEvent)new EndAction("end action", "com.github.structlogging.KafkaExample", 56L, "EndAction", SidCounter.incrementAndGet(), "AUDIT", 2L));
    }

    private static Producer<Long, LoggingEvent> createProducer(String bootstrap) {
        Properties props = KafkaExample.createProps(bootstrap);
        return new KafkaProducer(props);
    }

    private static Properties createProps(String bootstrap) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrap);
        props.put("client.id", "KafkaExampleProducer");
        props.put("key.serializer", LongSerializer.class.getName());
        props.put("value.serializer", LoggingEventJsonSerializer.class.getName());
        return props;
    }
}

