package com.webapp.utils.builder;

import java.util.Properties;

import org.nutz.dao.Dao;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.SimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.webapp.utils.mybatis.ClassBuilder;
import com.webapp.utils.mybatis.ClassCompiler;

public final class TableBuilder<T> {

	public enum CMT {
		UP(1), RIGHT(2);
		private int index;
		CMT(int index){
			this.index = index;
		}
		public int getIndex() {
			return index;
		}
	}

	private static int comment = 0;
	private static boolean snake = true;
	private static String jdbcCfg = "";
	private static boolean allNull = false;

	private static int deci_length = 8;
	private static int deci_precision = 4;

	public static int getComment() {
		return comment;
	}
	public static void setComment(CMT cmt) {
		TableBuilder.comment = cmt.getIndex();
	}
	public static boolean isSnake() {
		return snake;
	}
	public static void setSnake(boolean snake) {
		TableBuilder.snake = snake;
	}
	public static String getJdbcCfg() {
		return jdbcCfg;
	}
	public static void setJdbcCfg(String jdbcCfg) {
		TableBuilder.jdbcCfg = jdbcCfg;
	}
	public static boolean isAllNull() {
		return allNull;
	}
	public static void setAllNull(boolean allNull) {
		TableBuilder.allNull = allNull;
	}
	public static int getDeciLength() {
		return deci_length;
	}
	public static int getDeciPrecision() {
		return deci_precision;
	}
	public static void setPrecision(Integer length, Integer precision) {
		deci_length = length;
		deci_precision = precision;
	}



	private static final Logger logger = LoggerFactory.getLogger(TableBuilder.class);
	private static SimpleDataSource ds;
	public static <T> ClassBuilder<T> of(Class<T> clz) {
		return new ClassBuilder<T>(clz);
	}

	public static void build(String jdbcCfg, String clzStr, String pkg, String name) {
		if(ds == null){
			ds = buildDataSource(jdbcCfg);
		}

		Class<?> compile = ClassCompiler.compile(pkg + "." + name ,clzStr);
		Dao dao = new NutDao(ds);
		dao.create(compile, true);
	}

	private static SimpleDataSource buildDataSource(String jdbcCfg){
		Properties jdbc = new Properties();
		try {
	        jdbc.load(MybatisBuilder.class.getResourceAsStream("/" + jdbcCfg));
        } catch (Exception e) {
        	logger.error("read jdbcCfg error ", e);
        }

		SimpleDataSource ds = new SimpleDataSource();
		try {
			ds.setDriverClassName(jdbc.getProperty("driver"));
		} catch (ClassNotFoundException e) {
			logger.error("load jdbc driver error ", e);
		}
		ds.setJdbcUrl(jdbc.getProperty("url"));
		ds.setUsername(jdbc.getProperty("username"));
		ds.setPassword(jdbc.getProperty("password"));
		return ds;
	}


}
