package com.webapp.utils.builder;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.webapp.utils.string.Utils;

import cn.org.rapid_framework.generator.GeneratorControl;
import cn.org.rapid_framework.generator.GeneratorFacade;
import cn.org.rapid_framework.generator.GeneratorProperties;

public final class MybatisBuilder {

	private static final Logger logger = LoggerFactory.getLogger(MybatisBuilder.class);
//	private static String jdbcCfg = "";
//	private static void setJdbcCfg(String jdbcCfg) {
//		MybatisBuilder.jdbcCfg = jdbcCfg;
//	}


	private static final String PASSWORD = "password";
	private static final String USERNAME = "username";
	private static final String DRIVER = "driver";
	private static final String URL = "url";

	public enum TemplatType {
		simple("classpath:/template/simple"),
		view("classpath:/template/view");
		TemplatType(String template){
			this.template = template;
		}
		private String template;
		public String getTemplate() {
			return template;
		}
	}

	public static void viewProp(String jdbcCfg) {
		if(!setCfg(jdbcCfg)) return;
		Properties props = GeneratorProperties.getProperties();

		TreeMap<String, String> map = new TreeMap<String, String>();
		Enumeration<Object> keys = props.keys();
		while(keys.hasMoreElements()){
			Object next = keys.nextElement();
			map.put(next.toString(), props.getProperty(next.toString()));
		}

		Iterator<String> iterator = map.keySet().iterator();
		while(iterator.hasNext()){
			String next = iterator.next();
			logger.info("{} --> {}", next, map.get(next));
		}
	}

	public static void buildByTable(String jdbcCfg, String basePkg, List<String> tables) {
		buildByTable(jdbcCfg, basePkg, false, tables);
    }

	public static void buildByTable(String jdbcCfg, String basePkg, boolean suffix, List<String> tables) {
		GeneratorFacade gf = build(jdbcCfg, basePkg, suffix);
		tables.forEach(x->Utils.toSnake(x));
		try {
			gf.deleteOutRootDir();
			gf.generateByTable(tables.toArray(new String[]{}));
		} catch (Exception e) {
			logger.error(" error buildByTable ", e);
		}
	}

	public static void buildAll(String jdbcCfg, String basePkg) {
		buildAll(jdbcCfg, basePkg, false);
    }

	public static void buildAll(String jdbcCfg, String basePkg, boolean suffix) {
		GeneratorFacade gf = build(jdbcCfg, basePkg, suffix);
		try {
			gf.deleteOutRootDir();
			gf.generateByAllTable();
        } catch (Exception e) {
	        logger.error(" error buildAll ", e);
        }
    }

	private static GeneratorFacade build(String jdbcCfg, String basePkg, boolean suffix) {
		if(!setCfg(jdbcCfg)) return null;

		tableName();

		GeneratorProperties.setProperty("basepkg", basePkg);
		if(basePkg != null) {
			GeneratorProperties.setProperty("basepkg_dao", suffix ? basePkg + ".dao" : basePkg.replace("model", "dao"));
			GeneratorProperties.setProperty("basepkg_model", suffix ? basePkg + ".model" : basePkg.replace("dao", "model"));
		}
		GeneratorControl gc = new GeneratorControl();
		gc.setOverride(true);

		GeneratorFacade gf = new GeneratorFacade();
		gf.getGenerator().addTemplateRootDir(TemplatType.simple.getTemplate());
		return gf;
	}

	private static boolean setCfg(String jdbcCfg){
		GeneratorProperties.setProperty("outRoot", System.getProperty("user.dir") + "/codes/");

		Properties jdbc = new Properties();
		try {
			if(jdbcCfg.equals("")){
				logger.error("please call setJdbcCfg()");
				return false;
			}
	        jdbc.load(MybatisBuilder.class.getResourceAsStream("/" + jdbcCfg));
        } catch (Exception e) {
        	logger.error("classpath not exist " + jdbcCfg);
        	return false;
        }

		setJdbc(jdbc, URL);
		setJdbc(jdbc, DRIVER);
		setJdbc(jdbc, USERNAME);
		setJdbc(jdbc, PASSWORD);
		return true;
	}

	private static void setJdbc(Properties jdbc, String key) {
		String jdbc_key = "jdbc_" + key;

		if(jdbc.containsKey(jdbc_key)){
			GeneratorProperties.setProperty(jdbc_key, jdbc.getProperty(jdbc_key));
		}else if (jdbc.containsKey(key)) {
			GeneratorProperties.setProperty(jdbc_key, jdbc.getProperty(key));
		}else {
			logger.error("Must contain {} or {} configuration", jdbc_key, key);
		}
	}

	private static void tableName() {
		tableName(null);
    }

	private static void tableName(List<String> tables) {
    	try {
    		String jdbc_driver = GeneratorProperties.getProperty("jdbc_driver");
        	String jdbc_user = GeneratorProperties.getProperty("jdbc_username");
        	String jdbc_pwd = GeneratorProperties.getProperty("jdbc_password");
        	String jdbc_url = GeneratorProperties.getProperty("jdbc_url");
        	Class.forName(jdbc_driver);
        	Connection conn = DriverManager.getConnection(jdbc_url, jdbc_user, jdbc_pwd);
            ResultSet resultSet = conn.getMetaData().getTables(null, "%", "%", new String[] { "TABLE" });

            StringBuffer buf = new StringBuffer();
            while (resultSet.next()) {
            	String tableName = resultSet.getString("TABLE_NAME");
            	if(tables != null && !tables.contains(tableName)){
            		continue;
            	}
                String sql = "select table_comment from information_schema.TABLES where TABLE_SCHEMA='%1s' and table_name = '%2s'";
                sql = String.format(sql, resultSet.getString("TABLE_CAT"), tableName);
                ResultSet set = conn.prepareStatement(sql).executeQuery();
                if(set.next()){
                	String comment = set.getString("table_comment");
                	buf.append(tableName + "->" + comment + "<-");
//                	GeneratorProperties.setProperty("remarks_"+ tableName, comment);
                }
            }

            String result = buf.toString();
            if(!result.equals("")){
            	result = StringUtils.removeEnd(result, "<-");
            }
            GeneratorProperties.setProperty("remarks", result);
    	}catch (Exception e){
    		e.printStackTrace();
    	}
    }

}
