package com.webapp.utils.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;

public class MavenUtils {

	private static String base = "";
	private static String url = "";
	private static String repos = "";

	public static void show() {
		System.out.println("upThirdJarAndPom(\"C:/Users/king/Desktop\", \"/com\", \"http://ip:8081/nexus/content/repositories/thirdparty/\", \"dev.releases\");");
		System.out.println("upSnapsJarAndPom(\"C:/Users/king/Desktop\", \"/com\", \"http://ip:8081/nexus/content/repositories/snapshots/\", \"dev.releases\");");
	}
	public static void upThirdJarAndPom(String base, String relative, String url, String repos) {
		upJarAndPom(base, relative, url, repos, false);
	}
	public static void upSnapsJarAndPom(String base, String relative, String url, String repos) {
		upJarAndPom(base, relative, url, repos, true);
	}
	private static void upJarAndPom(String base, String relative, String url, String repos, boolean isSnap) {
		MavenUtils.base = base;
		MavenUtils.url = url;
		MavenUtils.repos = repos;
		loop(base+relative, isSnap);
	}

	private static void loop(String dir, boolean isSnap) {
		File[] files = new File(dir).listFiles();
		String jar = "";
		String pom = "";
		for(File file : files){
			if(file.isDirectory()){
				loop(file.getAbsolutePath(), isSnap);
			}
			if(file.isFile()){
				String name = file.getName();
				if(name.matches(".+\\d{8}\\.\\d{6}.+")) continue;
				if(isSnap){
					if(name.endsWith("-SNAPSHOT.jar")){
						jar = name;
					}else if(name.endsWith("-SNAPSHOT.pom")){
						pom = name;
					}
				}else {
					if(!name.endsWith("-SNAPSHOT.jar") && name.endsWith(".jar")){
						jar = name;
					}else if(!name.endsWith("-SNAPSHOT.pom") && name.endsWith(".pom")){
						pom = name;
					}
				}
			}
		}
		if(!(jar+pom).isEmpty()) {
			upload(files[0].toPath().getParent(), jar, pom);
		}
	}

	private static void upload(Path path, String jar, String pom) {
		int count = path.getNameCount();

		String groupId = Paths.get(base).relativize(path.getParent().getParent()).toString().replace("\\", ".");
		String artifactId = path.getName(count-2).toString();
		String version = path.getName(count-1).toString();

		StringBuffer mvn = new StringBuffer();
		mvn.append("mvn deploy:deploy-file ");
		mvn.append("-DgroupId=%1$s ");
		mvn.append("-DartifactId=%2$s ");
		mvn.append("-Dversion=%3$s ");
		mvn.append("-Dpackaging=%4$s ");
		mvn.append("-Durl=%5$s ");
		mvn.append("-DrepositoryId=%6$s ");
		mvn.append("-Dfile=%7$s ");
		if(!jar.isEmpty() && !pom.isEmpty()) mvn.append("-DpomFile=%8$s");

		String cmd = "";
		if(!pom.isEmpty() && jar.isEmpty()){
			cmd = String.format(mvn.toString(), groupId, artifactId, version, "pom", url, repos, path.resolve(pom));
		}else if(!jar.isEmpty() && pom.isEmpty()){
			cmd = String.format(mvn.toString(), groupId, artifactId, version, "jar", url, repos, path.resolve(jar));
		}else{
			cmd = String.format(mvn.toString(), groupId, artifactId, version, "jar", url, repos, path.resolve(jar), path.resolve(pom));
		}
		try {
			System.out.println(cmd);
			Process exec = Runtime.getRuntime().exec("cmd /c " + cmd);
			BufferedReader reader = new BufferedReader(new InputStreamReader(exec.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
		} catch (Exception e) {
			e.printStackTrace();
			try {
				Thread.sleep(1000000);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			}
		}
	}

}
