/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.config;

import com.webapp.utils.config.PathUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.plist.PropertyListConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtils.class);
    private static CompositeConfiguration composite;

    public static Properties read(String path) {
        Properties p = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(PathUtils.getPath(path).toString()));){
            p.load(in);
        }
        catch (IOException e) {
            logger.error(ConfigUtils.class.getSimpleName() + " \u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            throw new RuntimeException(ConfigUtils.class.getSimpleName() + " \u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6\u51fa\u9519");
        }
        return p;
    }

    public static Properties configConverter(Configuration config) {
        return ConfigurationConverter.getProperties((Configuration)config);
    }

    public static CompositeConfiguration getConfig() {
        if (composite == null) {
            composite = new CompositeConfiguration();
        }
        return composite;
    }

    public static CompositeConfiguration addDirConfig(String path, String ... suffix) {
        Path dir = Paths.get(path, new String[0]);
        if (dir.toString().equals("\\") || !Files.isDirectory(dir, new LinkOption[0])) {
            dir = PathUtils.getPath(path);
        }
        return ConfigUtils.addDirConfig(dir, suffix);
    }

    public static CompositeConfiguration addDirConfig(Path path, String ... suffix) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path entry : stream) {
                ConfigUtils.addConfig(entry.toString());
            }
        }
        catch (IOException e) {
            logger.error(" \u914d\u7f6e\u76ee\u5f55 ->" + path + " \u52a0\u8f7d\u51fa\u9519!", (Throwable)e);
        }
        return composite;
    }

    public static CompositeConfiguration addConfig(String ... path) {
        int k = path.length;
        for (int i = 0; i < k; ++i) {
            ConfigUtils.addConfig(path[i]);
        }
        return composite;
    }

    public static CompositeConfiguration addConfig(String config) {
        ConfigUtils.addConfig(ConfigUtils.getConfig(config));
        return composite;
    }

    public static CompositeConfiguration addConfig(Configuration config) {
        if (composite == null) {
            composite = new CompositeConfiguration();
        }
        composite.addConfiguration(config);
        return composite;
    }

    public static CompositeConfiguration addSystemConfig() {
        return ConfigUtils.addConfig((Configuration)new SystemConfiguration());
    }

    private static Configuration getConfig(String path) {
        try {
            if (!Paths.get(path, new String[0]).isAbsolute()) {
                path = PathUtils.getPath(path).toString();
            }
            if (path.endsWith(".properties")) {
                PropertiesConfiguration config = new PropertiesConfiguration(path);
                config.setReloadingStrategy((ReloadingStrategy)ConfigUtils.getReloading());
                return config;
            }
            if (path.endsWith(".xml")) {
                XMLConfiguration config = new XMLConfiguration(path);
                config.setReloadingStrategy((ReloadingStrategy)ConfigUtils.getReloading());
                return config;
            }
            if (path.endsWith(".plist")) {
                PropertyListConfiguration config = new PropertyListConfiguration(path);
                config.setReloadingStrategy((ReloadingStrategy)ConfigUtils.getReloading());
                return config;
            }
        }
        catch (ConfigurationException e) {
            logger.error(" \u914d\u7f6e\u6587\u4ef6 ->" + path + " \u52a0\u8f7d\u51fa\u9519!", (Throwable)e);
        }
        return null;
    }

    private static FileChangedReloadingStrategy getReloading() {
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        strategy.setRefreshDelay(5000L);
        return strategy;
    }
}

