/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.db;

import com.webapp.utils.string.Utils;
import java.lang.reflect.Field;

public final class MybatisUtils {
    private MybatisUtils() {
    }

    public static <T> void propSet(Class<T> clz) {
        Field[] fields;
        StringBuffer columns = new StringBuffer();
        String name = clz.getSimpleName();
        String camel = Utils.toCamel(name);
        columns.append(name + " " + camel + " = new " + name + "();\n");
        for (Field field : fields = clz.getDeclaredFields()) {
            String col = field.getName();
            columns.append(camel + ".set" + Utils.toPascal(col) + "();\n");
        }
        String result = Utils.delTail(columns.toString());
        System.out.println(result);
    }

    public static <T> void insertCols(Class<T> clz) {
        MybatisUtils.sql_insert(clz, false);
    }

    public static <T> void insertVals(Class<T> clz) {
        MybatisUtils.sql_insert(clz, true);
    }

    private static <T> void sql_insert(Class<T> clz, boolean isProp) {
        Field[] fields;
        StringBuffer columns = new StringBuffer();
        for (Field field : fields = clz.getDeclaredFields()) {
            String col = field.getName();
            if (isProp) {
                columns.append("#{" + col + "},");
                continue;
            }
            columns.append(Utils.toSnake(col) + ',');
        }
        String result = Utils.delTail(columns.toString());
        System.out.println(result);
    }

    public static <T> void searchCols(Class<T> clz) {
        Field[] fields;
        StringBuffer columns = new StringBuffer();
        for (Field field : fields = clz.getDeclaredFields()) {
            String col = field.getName();
            String consts = Utils.toSnake(col);
            columns.append(consts + (consts.contains("_") ? " " + col : "") + ",");
        }
        String result = Utils.delTail(columns.toString());
        System.out.println(result);
    }

    public static <T> void updateCols(Class<T> clz) {
        Field[] fields;
        StringBuffer columns = new StringBuffer();
        for (Field field : fields = clz.getDeclaredFields()) {
            String col = field.getName();
            String consts = Utils.toSnake(col);
            columns.append(consts + "=#{" + col + "},");
        }
        String result = Utils.delTail(columns.toString());
        System.out.println(result);
    }

    public static <T> void propConst(Class<T> clz) {
        Field[] fields;
        StringBuffer columns = new StringBuffer();
        for (Field field : fields = clz.getDeclaredFields()) {
            String col = field.getName();
            columns.append("public final static String ");
            String consts = Utils.toSnake(col);
            columns.append(consts.toUpperCase() + " = \"" + consts.toLowerCase() + "\";\n");
        }
        String result = Utils.delTail(columns.toString());
        System.out.println(result);
    }
}

