/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.enums;

import com.webapp.utils.clz.ClzUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public final class EnumUtils {
    private EnumUtils() {
    }

    @SafeVarargs
    public static <E extends Enum<E>> List<String> getList(Class<E> clz, String prop, E ... excludes) {
        Field field = ClzUtils.getField(clz, prop);
        ArrayList<String> result = new ArrayList<String>();
        if (field == null) {
            return result;
        }
        EnumSet<Enum> allOf = EnumSet.allOf(clz);
        if (excludes != null) {
            allOf.removeAll(Arrays.asList(excludes));
        }
        for (Enum next : allOf) {
            result.add(ClzUtils.getFieldVal(field, (Object)next).toString());
        }
        return result;
    }

    @SafeVarargs
    public static <E extends Enum<E>, T> List<T> getList(Class<E> clz, String prop, Class<T> returnType, E ... excludes) {
        Field field = ClzUtils.getField(clz, prop);
        ArrayList<Object> result = new ArrayList<Object>();
        if (field == null) {
            return result;
        }
        EnumSet<Enum> allOf = EnumSet.allOf(clz);
        if (excludes != null) {
            allOf.removeAll(Arrays.asList(excludes));
        }
        for (Enum next : allOf) {
            result.add(ClzUtils.getFieldVal(field, (Object)next));
        }
        return result;
    }

    public static <E extends Enum<E>> String valueOf(E enumEle, String prop) {
        Field field = ClzUtils.getField(enumEle.getClass(), prop);
        if (field == null) {
            return null;
        }
        return ClzUtils.getFieldVal(field, enumEle).toString();
    }

    public static <E extends Enum<E>> boolean isNotExist(Class<E> clz, String prop, Object value) {
        return !EnumUtils.isExist(clz, prop, value);
    }

    public static <E extends Enum<E>> boolean isExist(Class<E> clz, String prop, Object value) {
        return EnumUtils.getEnum(clz, prop, value) != null;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clz, String name) {
        for (Enum next : EnumSet.allOf(clz)) {
            if (!next.name().equals(name)) continue;
            return (E)next;
        }
        return null;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clz, String prop, Object value) {
        Field field = ClzUtils.getField(clz, prop);
        if (field == null) {
            return null;
        }
        for (Enum next : EnumSet.allOf(clz)) {
            if (!ClzUtils.getFieldVal(field, (Object)next).equals(value)) continue;
            return (E)next;
        }
        return null;
    }

    @SafeVarargs
    public static <E extends Enum<E>> List<E> getEnums(E[] all, E ... excludes) {
        ArrayList<E> result = new ArrayList<E>(Arrays.asList(all));
        result.removeAll(Arrays.asList(excludes));
        return result;
    }
}

