/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.AfterFilter;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PascalNameFilter;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.webapp.utils.string.Utils;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class JSONUtils {
    private Object jsonObj;
    private JSONSerializer jsonSerializer;
    private static final ThreadLocal<JSONUtils> local = new ThreadLocal();

    private JSONUtils(Object object) {
        this.jsonObj = object;
        this.jsonSerializer = new JSONSerializer(new SerializeConfig());
    }

    private JSONUtils setData(Object jsonObj, JSONSerializer jsonSerializer) {
        this.jsonObj = jsonObj;
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    private static JSONUtils localData(Object object) {
        if (local.get() == null) {
            local.set(new JSONUtils(object));
        }
        return local.get().setData(object, new JSONSerializer(new SerializeConfig()));
    }

    public static JSONUtils of(Object object) {
        return JSONUtils.localData(object);
    }

    public static String toString(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public String toCamelKey() {
        this.jsonSerializer.getNameFilters().add(new NameFilter(){

            public String process(Object object, String name, Object value) {
                return Utils.toCamel(name);
            }
        });
        return this.toString();
    }

    public String toPascalKey() {
        this.jsonSerializer.getNameFilters().add(new PascalNameFilter());
        return this.toString();
    }

    public String toSnakeKey() {
        this.jsonSerializer.getNameFilters().add(new NameFilter(){

            public String process(Object object, String name, Object value) {
                return Utils.toSnake(name);
            }
        });
        return this.toString();
    }

    public String toString() {
        this.jsonSerializer.write(this.jsonObj);
        return this.jsonSerializer.toString();
    }

    public String toPrettyString() {
        this.jsonSerializer.config(SerializerFeature.PrettyFormat, true);
        return this.toString();
    }

    public String toBeanToArray() {
        this.jsonSerializer.config(SerializerFeature.BeanToArray, true);
        return this.toString();
    }

    public JSONUtils before(final String key, final Object value) {
        this.jsonSerializer.getBeforeFilters().add(new BeforeFilter(){

            public void writeBefore(Object object) {
                this.writeKeyValue(key, value);
            }
        });
        return this;
    }

    public JSONUtils after(final String key, final Object value) {
        this.jsonSerializer.getAfterFilters().add(new AfterFilter(){

            public void writeAfter(Object object) {
                this.writeKeyValue(key, value);
            }
        });
        return this;
    }

    public JSONUtils include(String ... includes) {
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter(includes);
        this.jsonSerializer.getPropertyPreFilters().add(filter);
        return this;
    }

    public JSONUtils exclude(String ... excludes) {
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
        filter.getExcludes().addAll(Arrays.asList(excludes));
        this.jsonSerializer.getPropertyPreFilters().add(filter);
        return this;
    }

    public JSONUtils modifyKey(final String key, final String replacement) {
        this.jsonSerializer.getNameFilters().add(new NameFilter(){

            public String process(Object object, String name, Object value) {
                return key.equals(name) ? replacement : name;
            }
        });
        return this;
    }

    public JSONUtils modifyVal(final String key, final Object replacement) {
        this.jsonSerializer.getValueFilters().add(new ValueFilter(){
            String orgKey;
            List<NameFilter> nameFilters;
            {
                this.orgKey = key;
                this.nameFilters = JSONUtils.this.jsonSerializer.getNameFilters();
            }

            public Object process(Object object, String name, Object value) {
                for (NameFilter filter : this.nameFilters) {
                    this.orgKey = filter.process(object, this.orgKey, value);
                }
                return this.orgKey.equals(name) ? replacement : value;
            }
        });
        return this;
    }

    public JSONUtils modifyVal(final String key, final String regexVal, final String replacement) {
        this.jsonSerializer.getValueFilters().add(new ValueFilter(){
            String orgKey;
            List<NameFilter> nameFilters;
            {
                this.orgKey = key;
                this.nameFilters = JSONUtils.this.jsonSerializer.getNameFilters();
            }

            public Object process(Object object, String name, Object value) {
                for (NameFilter filter : this.nameFilters) {
                    this.orgKey = filter.process(object, this.orgKey, value);
                }
                if (this.orgKey.equals(name) && String.valueOf(value).matches(regexVal)) {
                    value = replacement;
                }
                return value;
            }
        });
        return this;
    }

    public JSONUtils filterVal(final String key, final String regexVal) {
        PropertyFilter filter = new PropertyFilter(){

            public boolean apply(Object object, String name, Object value) {
                return key.equals(name) ? String.valueOf(value).matches(regexVal) : true;
            }
        };
        this.jsonSerializer.getPropertyFilters().add(filter);
        return this;
    }

    public JSONUtils dateFormat(String format) {
        this.jsonSerializer.getMapping().put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer(format));
        return this;
    }

    public <T> JSONUtils doubleFormat(final String pattern, final Class<T> clz) {
        this.jsonSerializer.getValueFilters().add(new ValueFilter(){
            DecimalFormat format;
            List<NameFilter> nameFilters;
            {
                this.format = new DecimalFormat(pattern);
                this.nameFilters = JSONUtils.this.jsonSerializer.getNameFilters();
            }

            public Object process(Object object, String name, Object value) {
                Field[] fields;
                for (Field field : fields = clz.getDeclaredFields()) {
                    if (!field.getType().getSimpleName().equalsIgnoreCase(Double.TYPE.getSimpleName())) continue;
                    String key = field.getName();
                    for (NameFilter filter : this.nameFilters) {
                        key = filter.process(null, key, null);
                    }
                    if (!key.equals(name)) continue;
                    return this.format.format(value);
                }
                return value;
            }
        });
        return this;
    }

    public JSONUtils toCompatible() {
        this.jsonSerializer.config(SerializerFeature.BrowserCompatible, true);
        return this;
    }

    public JSONUtils toSort() {
        this.jsonSerializer.config(SerializerFeature.SortField, true);
        return this;
    }

    public JSONUtils toNullNumAsZero() {
        this.jsonSerializer.config(SerializerFeature.WriteNullNumberAsZero, true);
        return this;
    }

    public JSONUtils toNullBoolAsFalse() {
        this.jsonSerializer.config(SerializerFeature.WriteNullBooleanAsFalse, true);
        return this;
    }

    public JSONUtils toNullStrAsEmpty() {
        this.jsonSerializer.config(SerializerFeature.WriteNullStringAsEmpty, false);
        return this;
    }

    public JSONUtils toNonStrKeyAsStr() {
        this.jsonSerializer.config(SerializerFeature.WriteNonStringKeyAsString, true);
        return this;
    }

    public JSONUtils toMapNullValue() {
        this.jsonSerializer.config(SerializerFeature.WriteMapNullValue, true);
        return this;
    }

    public JSONUtils toNullListAsEmpty() {
        this.jsonSerializer.config(SerializerFeature.WriteNullListAsEmpty, true);
        return this;
    }

    public JSONUtils addNameFilter(NameFilter filter) {
        this.jsonSerializer.getNameFilters().add(filter);
        return this;
    }

    public JSONUtils addValueFilters(ValueFilter filter) {
        this.jsonSerializer.getValueFilters().add(filter);
        return this;
    }

    public JSONUtils addPropertyFilter(PropertyFilter filter) {
        this.jsonSerializer.getPropertyFilters().add(filter);
        return this;
    }

    public JSONUtils addPropertyPreFilter(PropertyPreFilter filter) {
        this.jsonSerializer.getPropertyPreFilters().add(filter);
        return this;
    }
}

