/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.string;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public final class IDUtils {
    private static final int[] checkCodes = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private ID id;
    private List<String> errorMsgs = new ArrayList<String>();
    private String addr = "";

    public static IDUtils of(String num) {
        return new IDUtils(num);
    }

    private IDUtils(String num) {
        this.id = new ID(num.length() >= 18 ? num : "0000000000000000000");
    }

    public String getBirth() {
        return this.id.getBirth().substring(0, 4) + "\u5e74" + this.id.getBirth().substring(4, 6) + "\u6708" + this.id.getBirth().substring(6, 8) + "\u65e5";
    }

    public String getSex() {
        return this.id.getSeq().charAt(2) % 2 == 0 ? "\u5973" : "\u7537";
    }

    public String getAddr() {
        if ("".equals(this.addr)) {
            this.checkAddr();
        }
        return this.addr;
    }

    public boolean checkAll() {
        if (!this.checkLength()) {
            return false;
        }
        return this.checkBirth() & this.checkCode() & this.checkAddr();
    }

    public boolean checkLength() {
        int length = this.id.getNum().length();
        if (length == 18) {
            return true;
        }
        this.errorMsgs.add("\u8eab\u4efd\u8bc1\u957f\u5ea6\u4e0d\u6b63\u786e");
        return false;
    }

    public boolean checkBirth() {
        int day;
        int month;
        int year;
        String birth = this.id.getBirth();
        try {
            year = Integer.valueOf(birth.substring(0, 4));
            month = Integer.valueOf(birth.substring(4, 6));
            day = Integer.valueOf(birth.substring(6, 8));
        }
        catch (NumberFormatException e) {
            this.errorMsgs.add("\u8eab\u4efd\u8bc1\u751f\u65e5\u7801\u4e0d\u6b63\u786e\uff01");
            return false;
        }
        if (year >= 1900 && year <= 2010 && month >= 1 && month <= 12 && day >= 1 && day <= 31) {
            return true;
        }
        this.errorMsgs.add("\u8eab\u4efd\u8bc1\u751f\u65e5\u7801\u4e0d\u6b63\u786e\uff01");
        return false;
    }

    public boolean checkAddr() {
        String addrCode = this.id.getAddr();
        this.addr = IDUtils.readAddress(addrCode);
        if (this.addr == null) {
            this.errorMsgs.add("\u8eab\u4efd\u8bc1\u5730\u5740\u7801\u4e0d\u6b63\u786e\uff01");
            return false;
        }
        return true;
    }

    public boolean checkCode() {
        String chCode = IDUtils.caculateCheckCode(this.id.getNum());
        if (!this.id.getCheck().equalsIgnoreCase(chCode)) {
            this.errorMsgs.add("\u8eab\u4efd\u8bc1\u6821\u9a8c\u7801\u4e0d\u6b63\u786e, \u6b63\u786e\u7684\u6821\u9a8c\u7801\u662f " + chCode);
            return false;
        }
        return true;
    }

    public String getErrorMsg() {
        return this.errorMsgs.size() > 0 ? this.errorMsgs.get(0) : "";
    }

    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    public static final int[] toInt(String num) {
        int i;
        int[] ins = new int[18];
        for (i = 0; i < ins.length - 1; ++i) {
            ins[i] = Integer.valueOf(num.substring(i, i + 1));
        }
        String last = num.substring(i, i + 1);
        ins[i] = "X".equals(last) ? 10 : Integer.valueOf(last);
        return ins;
    }

    private static final String caculateCheckCode(String num) {
        int total = 0;
        int[] ins = new int[18];
        try {
            for (int i = 0; i < ins.length - 1; ++i) {
                ins[i] = Integer.valueOf(num.substring(i, i + 1));
                total += ins[i] * checkCodes[i];
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        int modResult = total % 11;
        String result = null;
        switch (modResult) {
            case 0: {
                result = "1";
                break;
            }
            case 1: {
                result = "0";
                break;
            }
            case 2: {
                result = "X";
                break;
            }
            case 3: {
                result = "9";
                break;
            }
            case 4: {
                result = "8";
                break;
            }
            case 5: {
                result = "7";
                break;
            }
            case 6: {
                result = "6";
                break;
            }
            case 7: {
                result = "5";
                break;
            }
            case 8: {
                result = "4";
                break;
            }
            case 9: {
                result = "3";
                break;
            }
            case 10: {
                result = "2";
                break;
            }
        }
        return result;
    }

    private static final String readAddress(String addrNum) {
        char first = addrNum.charAt(0);
        if (first == '1' || first == '2' || first == '3' || first == '4' || first == '5' || first == '6') {
            String filePath = "/address/" + first + ".dic";
            String addr = IDUtils.readAddress(filePath, "UTF-8", addrNum);
            return addr;
        }
        return null;
    }

    private static final String readAddress(String filePath, String charset, String addrNum) {
        String addr = null;
        try {
            String line;
            InputStream is = IDUtils.class.getResourceAsStream(filePath);
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(is, charset));
            while ((line = buffReader.readLine()) != null) {
                if (!addrNum.equals(line.substring(0, 6))) continue;
                addr = line.substring(7, line.length());
                break;
            }
            buffReader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("\u627e\u5230\u4e0d\u5730\u5740\u7801\u6587\u4ef6");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("\u8bfb\u53d6\u5730\u5740\u7801\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        return addr;
    }

    private class ID {
        private String num;
        private String addr;
        private String birth;
        private String seq;
        private String check;

        public ID(String num) {
            this.num = num;
            this.addr = num.substring(0, 6);
            this.birth = num.substring(6, 14);
            this.seq = num.substring(14, 17);
            this.check = num.substring(17, 18);
        }

        public String getAddr() {
            return this.addr;
        }

        public String getBirth() {
            return this.birth;
        }

        public String getSeq() {
            return this.seq;
        }

        public String getCheck() {
            return this.check;
        }

        public String getNum() {
            return this.num;
        }
    }
}

