/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.string;

import com.webapp.utils.jpinyin.PinyinFormat;
import com.webapp.utils.jpinyin.PinyinHelper;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Utils {
    private Utils() {
    }

    public static String toPinyin(String str) {
        return Utils.toPinyin(str, "");
    }

    public static String toPinyin(String str, String separator) {
        return PinyinHelper.convertToPinyinString(str, separator, PinyinFormat.WITHOUT_TONE);
    }

    public static String toShortPinyin(String str) {
        return PinyinHelper.getShortPinyin(str);
    }

    public static String toSnake(String str) {
        if (str == null) {
            return null;
        }
        if (str.contains("_")) {
            return str.toLowerCase();
        }
        StringBuilder sb = new StringBuilder();
        boolean prevUpper = false;
        boolean curUpper = false;
        boolean nextUpper = false;
        for (int i = 0; i < str.length(); ++i) {
            char s = str.charAt(i);
            prevUpper = curUpper;
            curUpper = i == 0 ? Character.isUpperCase(s) : nextUpper;
            boolean bl = nextUpper = i < str.length() - 1 ? Character.isUpperCase(str.charAt(i + 1)) : true;
            if (String.valueOf(s).equals("_")) continue;
            if (!(i <= 0 || !curUpper || nextUpper && prevUpper)) {
                sb.append("_");
            }
            sb.append(Character.toLowerCase(s));
        }
        return sb.toString();
    }

    public static String toCamel(String str) {
        if (str == null) {
            return null;
        }
        if (str.contains("_")) {
            str = str.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(str.length());
        boolean upperCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (String.valueOf(c).equals("_")) {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return StringUtils.uncapitalize((String)sb.toString());
    }

    public static String toPascal(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.capitalize((String)Utils.toCamel(str));
    }

    public static String toEmail(String email) {
        return StringUtils.isEmpty((CharSequence)email) ? null : (email.contains("@gmail") ? "https://accounts.google.com" : "http://mail." + email.split("@")[1]);
    }

    public static boolean regexEmail(String email) {
        return StringUtils.isNotEmpty((CharSequence)email) && email.matches("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$");
    }

    public static boolean regexMobile(String phone) {
        return StringUtils.isNotEmpty((CharSequence)phone) && phone.matches("^(13[0-9]|14[5,7]|15[^4,\\D]|17[6-8]|18[0-9])\\d{8}$");
    }

    public static boolean regexIdcard(String idcard) {
        return StringUtils.isNotEmpty((CharSequence)idcard) && idcard.matches("^[1-9]([0-9]{14}|[0-9]{17})$");
    }

    public static String safedEmail(String email) {
        return Utils.safedEmail(email, 3);
    }

    public static String safedEmail(String email, int len) {
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            return email.replaceAll("(.{" + len + "})(?=@)", "***");
        }
        return null;
    }

    public static String safedMobile(String mobile) {
        if (StringUtils.isNotEmpty((CharSequence)mobile)) {
            return mobile.replaceAll("(?<=\\d{3})(.{4})(?=\\d{4})", "****");
        }
        return null;
    }

    public static <T> String split(List<T> list) {
        return Utils.split(list, ",");
    }

    public static <T> String split(List<T> list, String split) {
        StringBuffer result = new StringBuffer();
        list.forEach(item -> result.append(item + split));
        return StringUtils.removeEnd((String)result.toString(), (String)split);
    }

    public static String delTail(String str) {
        return Utils.delTail(str, ",");
    }

    public static String delTail(String str, String remove) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return StringUtils.removeEnd((String)str, (String)remove);
        }
        return "";
    }

    public static boolean isChinese(String str) {
        return Utils.isChinese(str, false);
    }

    public static boolean isChinese(String str, boolean hasSymbols) {
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!Utils.isChinese(c, hasSymbols)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChinese(char c, boolean hasSymbols) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
            return true;
        }
        return hasSymbols && (ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS);
    }

    public static String ascii2native(String ascii) {
        ArrayList<String> ascii_s = new ArrayList<String>();
        String regex = "\\\\u[0-9,a-f,A-F]{4}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(ascii);
        while (m.find()) {
            ascii_s.add(m.group());
        }
        int j = 2;
        for (int i = 0; i < ascii_s.size(); ++i) {
            String code = ((String)ascii_s.get(i)).substring(j, j + 4);
            char ch = (char)Integer.parseInt(code, 16);
            ascii = ascii.replace((CharSequence)ascii_s.get(i), String.valueOf(ch));
        }
        return ascii;
    }

    public static String str2Hex(String str) throws UnsupportedEncodingException {
        String hexRaw = String.format("%x", new BigInteger(1, str.getBytes("UTF-8")));
        char[] hexRawArr = hexRaw.toCharArray();
        StringBuilder hexFmtStr = new StringBuilder();
        String SEP = "\\x";
        for (int i = 0; i < hexRawArr.length; ++i) {
            hexFmtStr.append("\\x").append(hexRawArr[i]).append(hexRawArr[++i]);
        }
        return hexFmtStr.toString();
    }

    public static String hex2Str(String str) throws UnsupportedEncodingException {
        String[] strArr = str.split("\\\\");
        byte[] byteArr = new byte[strArr.length - 1];
        for (int i = 1; i < strArr.length; ++i) {
            Integer hexInt = Integer.decode("0" + strArr[i]);
            byteArr[i - 1] = hexInt.byteValue();
        }
        return new String(byteArr, "UTF-8");
    }

    public static interface Symbol {
        public static final String Enter = "\n";
        public static final String Tab = "\t";
        public static final String Empty = "";
        public static final String Space = " ";
        public static final String Dot = ".";
        public static final String Comma = ",";
        public static final String Colon = ":";
        public static final String Semicolon = ";";
        public static final String LineThrough = "-";
        public static final String LineUnder = "_";
        public static final String Pound = "#";
        public static final String Question = "?";
        public static final String And = "&";
        public static final String Dollar = "$";
        public static final String Percent = "%";
        public static final String At = "@";
        public static final String Slash = "/";
        public static final String Backslash = "\\";
        public static final String LParen = "(";
        public static final String RParen = ")";
        public static final String LBrace = "{";
        public static final String RBrace = "}";
        public static final String LBracket = "[";
        public static final String RBracket = "]";
    }

    public static interface Charsets {
        public static final String uft8 = StandardCharsets.UTF_8.name();
        public static final String gbk = "gbk";
        public static final String iso = StandardCharsets.ISO_8859_1.name();
    }
}

