/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.thread;

import java.util.concurrent.CompletionService;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ThreadUtils {
    public static final Logger logger = LoggerFactory.getLogger(ThreadUtils.class);
    public static final AtomicInteger threadCount = new AtomicInteger();
    public static final ExecutorService service = Executors.newCachedThreadPool();
    public static final CompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(service);

    public static <T extends Runnable> void testMultiCase(Supplier<T> run, int count, boolean isNanoTime) {
        int i;
        long startTime = isNanoTime ? System.nanoTime() : System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            Runnable t = (Runnable)run.get();
            completionService.submit(t, i);
        }
        for (i = 0; i < count; ++i) {
            try {
                completionService.take().get();
                continue;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u7ebf\u7a0b\u7ed3\u679c\u51fa\u9519", (Throwable)e);
            }
        }
        ThreadUtils.computeTime(startTime, isNanoTime);
    }

    public static <T extends Runnable> void testSimpleCase(T run, int count, boolean isNanoTime) {
        int i;
        long startTime = isNanoTime ? System.nanoTime() : System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            completionService.submit(run, i);
        }
        for (i = 0; i < count; ++i) {
            try {
                completionService.take().get();
                continue;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u7ebf\u7a0b\u7ed3\u679c\u51fa\u9519", (Throwable)e);
            }
        }
        ThreadUtils.computeTime(startTime, isNanoTime);
    }

    public static <T extends Runnable> void testMultiCase(Supplier<T> run, int count) {
        ThreadUtils.testMultiCase(run, count, false);
    }

    public static <T extends Runnable> void testSimpleCase(T run, int count) {
        ThreadUtils.testSimpleCase(run, count, false);
    }

    public static void testCAP(Consumer<Integer> cap, int loop, String name) {
        System.out.println(name);
        long startTime = System.nanoTime();
        for (int i = 0; i < loop; ++i) {
            cap.accept(i);
        }
        ThreadUtils.computeTime(startTime, true);
    }

    public static void testSimpleCAP(Consumer<Integer> cap, int loop) {
        long startTime = System.nanoTime();
        cap.accept(loop);
        ThreadUtils.computeTime(startTime, true);
    }

    public static void computeTime(long startTime, boolean isNanoTime) {
        if (isNanoTime && String.valueOf(startTime).length() <= 13) {
            System.out.println(startTime + "\u4e0d\u662f\u6b63\u786e\u7684\u7eb3\u79d2\u6570");
            return;
        }
        long endTime = isNanoTime ? System.nanoTime() : System.currentTimeMillis();
        long total = endTime - startTime;
        if (isNanoTime) {
            System.out.printf("total time = %s\u5fae\u79d2\t", total / 1000L);
            System.out.printf("\ntotal time = %s\u6beb\u79d2\t", total / 1000000L);
            System.out.printf("\ntotal time = %s\u79d2\t", total / 1000000000L);
            System.out.printf("\ntotal time = %s\u5206\t", total / 60000000000L);
        } else {
            System.out.printf("total time = %s\u6beb\u79d2\t", total);
            System.out.printf("\ntotal time = %s\u79d2\t", total / 1000L);
            System.out.printf("\ntotal time = %s\u5206\t", total / 1000L / 60L);
        }
        System.out.println();
        System.out.println();
    }

    public static void computeTime(long startTime) {
        ThreadUtils.computeTime(startTime, false);
    }

    public static void logCyclicBarrier(CyclicBarrier cb, String place) {
        int arrive = cb.getNumberWaiting() + 1;
        String name = Thread.currentThread().getName();
        System.out.printf("%s\u5df2\u7ecf\u5230\u8fbe\u96c6\u5408\u70b9%s, \u5f53\u524d\u6709%s\u4e2a\u5df2\u7ecf\u5230\u8fbe\t", name, place, arrive);
    }

    public static void logAcquire(Semaphore sp) throws InterruptedException {
        System.out.printf("tryAcquire=s, availablePermits=%s, queueLength=%s, queuedThreads=%s, isFair=%s\t", sp.availablePermits(), sp.getQueueLength(), sp.hasQueuedThreads(), sp.isFair());
        sp.acquire();
        System.out.printf("\u7ebf\u7a0b %s\u8fdb\u5165\uff0c\u5f53\u524d\u6709%d\u4e2a\u5e76\u53d1\t", Thread.currentThread().getName(), threadCount.incrementAndGet());
    }

    public static void logRelease(Semaphore sp) {
        sp.release();
        System.out.printf("\u7ebf\u7a0b %s\u79bb\u5f00\uff0c\u5f53\u524d\u6709%d\u4e2a\u5e76\u53d1\t", Thread.currentThread().getName(), threadCount.decrementAndGet());
    }
}

