/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.config;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathUtils {
    private static final Logger logger = LoggerFactory.getLogger(PathUtils.class);

    public static String getCurPath(Class<?> clz) {
        return PathUtils.encode(clz.getResource("")).toString();
    }

    public static String getUserPath() {
        return System.getProperty("user.dir");
    }

    public static String getClassPath() {
        return PathUtils.encode(PathUtils.getResource("/")).toString();
    }

    public static Path getPath(String path) {
        return PathUtils.encode(PathUtils.getResource(path));
    }

    public static Path getPath(String path, boolean isClasspath) {
        return PathUtils.encode(PathUtils.getResource(path, isClasspath));
    }

    public static boolean isExist(String path) {
        return Files.exists(Paths.get(PathUtils.getUserPath() + path, new String[0]), new LinkOption[0]);
    }

    public static URL getResource(String path) {
        return PathUtils.getResource(path, true);
    }

    public static URL getResource(String path, boolean isClasspath) {
        URL result = null;
        if (isClasspath) {
            result = PathUtils.class.getResource(path);
            if (result == null && !path.contains("/")) {
                result = PathUtils.class.getResource("/" + path);
            }
            return result;
        }
        try {
            result = Paths.get(path, new String[0]).toAbsolutePath().toUri().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Path encode(URI url) {
        return Paths.get(url);
    }

    private static Path encode(URL url) {
        try {
            return PathUtils.encode(url.toURI());
        }
        catch (URISyntaxException e) {
            logger.error(PathUtils.class.getSimpleName() + " URL\u8f6c\u6362URI\u51fa\u9519", (Throwable)e);
            throw new RuntimeException(PathUtils.class.getSimpleName() + " URL\u8f6c\u6362URI\u51fa\u9519");
        }
    }

    public static String getJavaPath() {
        return System.getProperty("sun.boot.library.path");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.runtime.version");
    }
}

