/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.datasort;

import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.ArrayUtils;

public final class DataSortUtils {
    private DataSortUtils() {
    }

    public static byte[] sort(byte[] data) {
        return DataSortUtils.sort(data, OrderType.binaryInsert_asce);
    }

    public static char[] sort(char[] data) {
        return DataSortUtils.sort(data, OrderType.binaryInsert_asce);
    }

    public static double[] sort(double[] data) {
        return DataSortUtils.sort(data, OrderType.binaryInsert_asce);
    }

    public static float[] sort(float[] data) {
        return DataSortUtils.sort(data, OrderType.binaryInsert_asce);
    }

    public static int[] sort(int[] data) {
        return DataSortUtils.sort(data, OrderType.binaryInsert_asce);
    }

    public static long[] sort(long[] data) {
        return DataSortUtils.sort(data, OrderType.binaryInsert_asce);
    }

    public static short[] sort(short[] data) {
        return DataSortUtils.sort(data, OrderType.binaryInsert_asce);
    }

    public static byte[] sort(byte[] data, OrderType type) {
        return ArrayUtils.toPrimitive((Byte[])((Byte[])DataSortUtils.getOrderSort((Comparable[])ArrayUtils.toObject((byte[])data), (OrderType)type)));
    }

    public static char[] sort(char[] data, OrderType type) {
        return ArrayUtils.toPrimitive((Character[])((Character[])DataSortUtils.getOrderSort((Comparable[])ArrayUtils.toObject((char[])data), (OrderType)type)));
    }

    public static double[] sort(double[] data, OrderType type) {
        return ArrayUtils.toPrimitive((Double[])((Double[])DataSortUtils.getOrderSort((Comparable[])ArrayUtils.toObject((double[])data), (OrderType)type)));
    }

    public static float[] sort(float[] data, OrderType type) {
        return ArrayUtils.toPrimitive((Float[])((Float[])DataSortUtils.getOrderSort((Comparable[])ArrayUtils.toObject((float[])data), (OrderType)type)));
    }

    public static int[] sort(int[] data, OrderType type) {
        return ArrayUtils.toPrimitive((Integer[])((Integer[])DataSortUtils.getOrderSort((Comparable[])ArrayUtils.toObject((int[])data), (OrderType)type)));
    }

    public static long[] sort(long[] data, OrderType type) {
        return ArrayUtils.toPrimitive((Long[])((Long[])DataSortUtils.getOrderSort((Comparable[])ArrayUtils.toObject((long[])data), (OrderType)type)));
    }

    public static short[] sort(short[] data, OrderType type) {
        return ArrayUtils.toPrimitive((Short[])((Short[])DataSortUtils.getOrderSort((Comparable[])ArrayUtils.toObject((short[])data), (OrderType)type)));
    }

    public static <T extends Comparable<T>> T[] sort(T[] data) {
        return DataSortUtils.sort(data, (OrderType)OrderType.binaryInsert_asce);
    }

    public static <T extends Comparable<T>> T[] sort(T[] data, OrderType type) {
        return DataSortUtils.getOrderSort(data, (OrderType)type);
    }

    public static <T extends Comparable<T>> List<T> sort(List<T> data) {
        return DataSortUtils.sort(data, OrderType.binaryInsert_asce);
    }

    public static <T extends Comparable<T>> List<T> sort(List<T> data, OrderType type) {
        return DataSortUtils.sort(data, type, null);
    }

    public static <T> T[] sort(T[] data, OrderType type, Comparator<T> comp) {
        return DataSortUtils.getOrderSort(data, type, comp);
    }

    public static <T> List<T> sort(List<T> data, OrderType type, Comparator<T> comp) {
        T[] tArr = null;
        tArr = data.toArray(tArr);
        DataSortUtils.getOrderSort(tArr, type, comp);
        ListIterator<T> i = data.listIterator();
        for (int j = 0; j < tArr.length; ++j) {
            i.next();
            i.set(tArr[j]);
        }
        return data;
    }

    private static <T> T[] shellSort(T[] data, Comparator<T> comp) {
        int length = data.length;
        int h = 1;
        while (h <= length / 3) {
            h = h * 3 + 1;
        }
        while (h > 0) {
            for (int i = h; i < length; ++i) {
                T tmp = data[i];
                if (DataSortUtils.compare(data[i], data[i - h], comp) >= 0) continue;
                for (int j = i - h; j >= 0 && DataSortUtils.compare(data[i], tmp, comp) > 0; j -= h) {
                    data[j + h] = data[j];
                }
                data[j + h] = tmp;
            }
            h = (h - 1) / 3;
        }
        return data;
    }

    private static <T> T[] binaryInsertSort(T[] data, Comparator<T> comp) {
        for (int i = 1; i < data.length; ++i) {
            T temp = data[i];
            int low = 0;
            int high = i - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                if (DataSortUtils.compare(temp, data[mid], comp) > 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            for (int j = i; j > low; --j) {
                data[j] = data[j - 1];
            }
            data[low] = temp;
        }
        return data;
    }

    private static <T> T[] insertSort(T[] data, Comparator<T> comp) {
        for (int i = 1; i < data.length; ++i) {
            T temp = data[i];
            if (DataSortUtils.compare(data[i], data[i - 1], comp) >= 0) continue;
            for (int j = i - 1; j >= 0 && DataSortUtils.compare(data[j], temp, comp) > 0; --j) {
                data[j + 1] = data[j];
            }
            data[j + 1] = temp;
        }
        return data;
    }

    private static <T> T[] quickSort(T[] data, Comparator<T> comp) {
        return DataSortUtils.quickSort(data, 0, data.length - 1, comp);
    }

    private static <T> T[] bubbleSort(T[] data, Comparator<T> comp) {
        for (int i = 0; i < data.length - 1; ++i) {
            boolean flag = false;
            for (int j = 0; j < data.length - 1 - i; ++j) {
                if (DataSortUtils.compare(data[j], data[j + 1], comp) <= 0) continue;
                DataSortUtils.swap(data, j, j + 1);
                flag = true;
            }
            if (!flag) break;
        }
        return data;
    }

    private static <T> T[] selectSort(T[] data, Comparator<T> comp) {
        int length = data.length;
        for (int i = 0; i < length - 1; ++i) {
            int minIndex = i;
            for (int j = i + 1; j < length; ++j) {
                if (DataSortUtils.compare(data[j], data[minIndex], comp) >= 0) continue;
                minIndex = j;
            }
            if (minIndex == i) continue;
            DataSortUtils.swap(data, minIndex, i);
        }
        return data;
    }

    private static <T> T[] heapSort(T[] data, Comparator<T> comp) {
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            DataSortUtils.buildMaxHeap(data, length - i, comp);
            DataSortUtils.swap(data, 0, length - i - 1);
        }
        return data;
    }

    private static <T> T[] buildMaxHeap(T[] data, int lastIndex, Comparator<T> comp) {
        int lastNode;
        block0: for (int i = lastNode = (lastIndex >> 1) - 1; i >= 0; --i) {
            int k = i;
            while ((k << 1) + 1 < lastIndex) {
                int bigIndex = (k << 1) + 1;
                if (bigIndex < lastIndex - 1) {
                    bigIndex += DataSortUtils.compare(data[bigIndex], data[bigIndex + 1], comp) < 0 ? 1 : 0;
                }
                if (DataSortUtils.compare(data[k], data[bigIndex], comp) >= 0) continue block0;
                DataSortUtils.swap(data, k, bigIndex);
                k = bigIndex;
            }
        }
        return data;
    }

    private static <T> T[] quickSort(T[] data, int start, int end, Comparator<T> comp) {
        if (start < end) {
            int i = start;
            int j = end + 1;
            while (i < j) {
                DataSortUtils.swap(data, i, j);
            }
            DataSortUtils.swap(data, start, j);
            DataSortUtils.quickSort(data, start, j - 1, comp);
            DataSortUtils.quickSort(data, j + 1, end, comp);
        }
        return data;
    }

    private static <T> void swap(T[] data, int i, int j) {
        T temp = data[i];
        data[i] = data[j];
        data[j] = temp;
    }

    private static <T extends Comparable<T>> T[] getOrderSort(T[] data, OrderType type) {
        return (Comparable[])DataSortUtils.getOrderSort(data, type, null);
    }

    private static <T> T[] getOrderSort(T[] data, OrderType type, Comparator<T> comp) {
        if (type == OrderType.binaryInsert_asce || type == OrderType.binaryInsert_desc) {
            DataSortUtils.binaryInsertSort(data, comp);
        } else if (type == OrderType.bubble_asce || type == OrderType.bubble_desc) {
            DataSortUtils.bubbleSort(data, comp);
        } else if (type == OrderType.heap_asce || type == OrderType.heap_desc) {
            DataSortUtils.heapSort(data, comp);
        } else if (type == OrderType.quick_asce || type == OrderType.quick_desc) {
            DataSortUtils.quickSort(data, comp);
        } else if (type == OrderType.insert_asce || type == OrderType.insert_desc) {
            DataSortUtils.insertSort(data, comp);
        } else if (type == OrderType.select_asce || type == OrderType.select_desc) {
            DataSortUtils.selectSort(data, comp);
        } else if (type == OrderType.shell_asce || type == OrderType.shell_desc) {
            DataSortUtils.shellSort(data, comp);
        } else {
            DataSortUtils.binaryInsertSort(data, comp);
        }
        if (type.getKey().endsWith(OrderType.desc.getKey())) {
            ArrayUtils.reverse((Object[])data);
        }
        return data;
    }

    private static <T> int compare(T comp1, T comp2, Comparator<T> comparator) {
        if (comparator == null) {
            Comparable comp = (Comparable)comp1;
            return comp.compareTo(comp2);
        }
        return comparator.compare(comp1, comp2);
    }

    public static enum OrderType {
        desc("desc", "\u964d\u5e8f"),
        asce("asce", "\u5347\u5e8f"),
        shell_desc("shell_desc", "\u63d2\u5165\u6392\u5e8f->Shell\u6392\u5e8f->\u7a33\u5b9a"),
        insert_desc("insert_desc", "\u63d2\u5165\u6392\u5e8f->\u76f4\u63a5\u63d2\u5165\u6392\u5e8f->\u7a33\u5b9a"),
        quick_desc("quick_desc", "\u4ea4\u6362\u6392\u5e8f->\u5feb\u901f\u6392\u5e8f->\u4e0d\u7a33\u5b9a"),
        bubble_desc("bubble_desc", "\u4ea4\u6362\u6392\u5e8f->\u5192\u6ce1\u6392\u5e8f->\u7a33\u5b9a"),
        heap_desc("heap_desc", "\u9009\u62e9\u6392\u5e8f ->\u5806\u6392\u5e8f->\u4e0d\u7a33\u5b9a"),
        select_desc("select_desc", "\u9009\u62e9\u6392\u5e8f ->\u76f4\u63a5\u9009\u62e9\u6392\u5e8f->\u5df2\u6539\u8fdb->\u4e0d\u7a33\u5b9a"),
        binaryInsert_desc("binaryInsert_desc", "\u63d2\u5165\u6392\u5e8f->\u6298\u534a\u63d2\u5165\u6392\u5e8f->\u7a33\u5b9a"),
        shell_asce("shell_asce", "\u63d2\u5165\u6392\u5e8f->Shell\u6392\u5e8f->\u7a33\u5b9a"),
        insert_asce("insert_asce", "\u63d2\u5165\u6392\u5e8f->\u76f4\u63a5\u63d2\u5165\u6392\u5e8f->\u7a33\u5b9a"),
        quick_asce("quick_asce", "\u4ea4\u6362\u6392\u5e8f->\u5feb\u901f\u6392\u5e8f->\u4e0d\u7a33\u5b9a"),
        bubble_asce("bubble_asce", "\u4ea4\u6362\u6392\u5e8f->\u5192\u6ce1\u6392\u5e8f->\u7a33\u5b9a"),
        heap_asce("heap_asce", "\u9009\u62e9\u6392\u5e8f ->\u5806\u6392\u5e8f->\u4e0d\u7a33\u5b9a"),
        select_asce("select_asce", "\u9009\u62e9\u6392\u5e8f ->\u76f4\u63a5\u9009\u62e9\u6392\u5e8f->\u5df2\u6539\u8fdb->\u4e0d\u7a33\u5b9a"),
        binaryInsert_asce("binaryInsert_asce", "\u63d2\u5165\u6392\u5e8f->\u6298\u534a\u63d2\u5165\u6392\u5e8f->\u7a33\u5b9a");

        private String key;
        private String comment;

        private OrderType(String key, String comment) {
            this.key = key;
            this.comment = comment;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

